/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.dataquality;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.rules.MetricsBasedDataQualityRule;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.MetricsService;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.DatasetCheckContext;
import com.dataiku.dip.metrics.probes.CheckProbeType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.dataquality.AbstractCheckReport;
import com.dataiku.dip.server.services.dataquality.AbstractValuedCheck;
import com.dataiku.dip.server.services.dataquality.DataQualityRulesLaunchService;
import com.dataiku.dip.server.services.dataquality.DataQualityService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataQualityRuleComputationService {
    @Autowired
    private MetricsService metricsService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private MetricsComputationService metricsComputationService;
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private DataQualityService dataQualityService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FlowGraphService flowGraphService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.data-quality");

    public Map<String, AbstractCheckReport.DataQualityRulesComputationReport> computeRules_NT(AuthCtx owner, Dataset dataset, List<DataQualityRule> rules, List<Partition> partitions, boolean computeForFullDataset, DataQualityRulesLaunchService.RunOptions options) throws Exception {
        return this.computeRules_NT(owner, dataset, rules, partitions, computeForFullDataset, false, options);
    }

    public Map<String, AbstractCheckReport.DataQualityRulesComputationReport> computeRulesAllPartitions_NT(AuthCtx owner, Dataset dataset, List<DataQualityRule> rules, boolean computeForFullDataset, DataQualityRulesLaunchService.RunOptions options) throws Exception {
        return this.computeRules_NT(owner, dataset, rules, null, computeForFullDataset, true, options);
    }

    private Map<String, AbstractCheckReport.DataQualityRulesComputationReport> computeRules_NT(AuthCtx owner, Dataset dataset, List<DataQualityRule> rules, List<Partition> partitions, boolean computeForFullDataset, boolean computeForAllPartitions, DataQualityRulesLaunchService.RunOptions options) throws Exception {
        HashMap<String, AbstractCheckReport.DataQualityRulesComputationReport> result = new HashMap<String, AbstractCheckReport.DataQualityRulesComputationReport>();
        boolean isDatasetSourceInFlow = this.isDatasetSourceInFlow_NT(dataset);
        boolean isPartitioned = dataset.getPartitioningSchema().isPartitioned();
        MetricsEngineDesc.MetricsEngineContext context = new MetricsEngineDesc.MetricsEngineContext(owner);
        if (computeForAllPartitions) {
            try (DatasetHandler datasetHandler = DatasetHandlerFactory.build(owner, dataset);){
                partitions = datasetHandler.listPartitions();
            }
            context.partitions = partitions;
        } else {
            computeForFullDataset |= partitions.stream().anyMatch(Partition::isAll);
            partitions = partitions.stream().filter(p -> !p.isAll()).collect(Collectors.toList());
        }
        MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
        environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
        boolean bl = environment.doNotSaveMetricValues = !options.saveMetricsResult;
        if (options.runOrigin.type.equals((Object)DataQualityRunOrigin.DataQualityRunType.BUILD)) {
            environment.startedFromBuild = true;
        }
        Object futureMessage = "Computing Data Quality rules";
        if (!partitions.isEmpty() && isPartitioned) {
            futureMessage = (String)futureMessage + String.format(" on %d partition%s", partitions.size(), partitions.size() == 1 ? "" : "s");
        }
        if (computeForFullDataset) {
            futureMessage = (String)futureMessage + (partitions.isEmpty() ? "" : " and");
            futureMessage = (String)futureMessage + " on the whole dataset";
        }
        try (FutureProgress.AutocloseableFutureProgressState s = FutureProgress.pushAutoCloseableState((String)futureMessage, (double)(2.0 * ((double)partitions.size() + (computeForFullDataset ? 1.0 : 0.0))), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            if (!partitions.isEmpty()) {
                List<DataQualityRule> rulesToCompute = this.getComputedRules(rules, PartitionSelection.PARTITION, options, isDatasetSourceInFlow, isPartitioned);
                ProbesSet probeSet = this.getProbesSet(dataset, rulesToCompute, options.computeAllMetrics);
                for (Partition partition : partitions) {
                    AbstractCheckReport.DataQualityRulesComputationReport res = this.computeRulesOnePartition_NT(owner, dataset, probeSet, rulesToCompute, context, environment, partition, options);
                    result.put(partition.id(), res);
                }
            }
            if (computeForFullDataset) {
                Partition partition = Partition.newALL((PartitioningScheme)dataset.getPartitioningSchema());
                List<DataQualityRule> rulesToCompute = this.getComputedRules(rules, PartitionSelection.WHOLE_DATASET, options, isDatasetSourceInFlow, isPartitioned);
                ProbesSet probeSet = this.getProbesSet(dataset, rulesToCompute, options.computeAllMetrics);
                AbstractCheckReport.DataQualityRulesComputationReport dataQualityRulesComputationReport = this.computeRulesOnePartition_NT(owner, dataset, probeSet, rulesToCompute, context, environment, partition, options);
                result.put(partition.id(), dataQualityRulesComputationReport);
            }
        }
        return result;
    }

    private List<DataQualityRule> getComputedRules(List<DataQualityRule> rules, PartitionSelection selectFor, DataQualityRulesLaunchService.RunOptions options, boolean isDatasetSourceInFlow, boolean isPartitioned) {
        return rules.stream().filter(rule -> rule.enabled || options.computeDisabledRules).filter(rule -> !rule.type.equals("external")).filter(rule -> isDatasetSourceInFlow || (rule.autoRun ? options.computeAutoRunRules : options.computeManualRules)).filter(rule -> {
            if (options.ignorePartitionSelectionMode || !isPartitioned) {
                return true;
            }
            if (selectFor == PartitionSelection.WHOLE_DATASET && !rule.getComputeMode().includesALL()) {
                logger.info((Object)("Full dataset rule " + rule.getId() + " is not active."));
                return false;
            }
            if (selectFor == PartitionSelection.PARTITION && !rule.getComputeMode().includesPartition()) {
                logger.info((Object)("Rule " + rule.getId() + " is not active."));
                return false;
            }
            if (options.runOrigin.type.equals((Object)DataQualityRunOrigin.DataQualityRunType.BUILD) && !rule.autoRun) {
                logger.info((Object)("Rule on build " + rule.getId() + " is not active."));
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private AbstractCheckReport.DataQualityRulesComputationReport computeRulesOnePartition_NT(AuthCtx owner, Dataset dataset, ProbesSet probeSet, List<DataQualityRule> rulesToCompute, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment, Partition partition, DataQualityRulesLaunchService.RunOptions options) throws Exception {
        String partitionId = partition.id();
        String logPrefix = String.format("Computing Data Quality rules for dataset %s on partition %s", dataset.getFullName(), partitionId);
        try {
            logger.trace(() -> "ProbesSet to compute: " + JSON.pretty((Object)probeSet));
            MetricsComputationService.MetricsComputationReport metricsReport = this.metricsComputationService.computeMetrics(owner, dataset, MetricTargetType.DATASET, partition, probeSet, context, environment);
            logger.info((Object)String.format("%s: done computing and saving metrics", logPrefix));
            FutureProgress.incrementState((double)1.0);
            logger.trace(() -> "RuleSet to compute: " + JSON.pretty((Object)rulesToCompute));
            DataQualityRuleChecksReport checksReport = this.checkDataset(owner, dataset, partition, rulesToCompute, environment, options, metricsReport.computed, metricsReport.startTime);
            logger.info((Object)String.format("%s: done running checks", logPrefix));
            FutureProgress.incrementState((double)1.0);
            long ruleComputationDoneTimestamp = DateTime.now().getMillis();
            if (!rulesToCompute.isEmpty() && options.saveRuleResult) {
                this.dataQualityService.updateDatasetStatusForPartitionsCascade_NT(dataset.getModel(), Collections.singletonList(partitionId), ruleComputationDoneTimestamp);
                logger.info((Object)String.format("%s: done updating dataset status", logPrefix));
            }
            return new AbstractCheckReport.DataQualityRulesComputationReport(String.format("dataset:%s partition:%s", dataset.getFullName(), partition.id()), metricsReport, checksReport.runs, checksReport.results, ruleComputationDoneTimestamp, dataset.getModel().flowOptions.ignoreErrorStatusOnBuild);
        }
        catch (Exception ex) {
            logger.error((Object)String.format("%s: Failed to compute rules", logPrefix), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataQualityRuleChecksReport checkDataset(AuthCtx user, Dataset dataset, Partition partition, List<DataQualityRule> rulesToCompute, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRulesLaunchService.RunOptions options, List<MetricsComputationService.ValuedMetric> computedMetrics, long metricsComputationTime) throws Exception {
        DataQualityRuleChecksReport report = new DataQualityRuleChecksReport();
        DateTime timeCheck = DateTime.now();
        APITicketService.Ticket ticket = this.apiTicketService.createTicket(user, "checks:DATASET." + dataset.getFullName(), (Object)dataset);
        DatasetCheckContext context = new DatasetCheckContext(dataset, partition, timeCheck.getMillis(), this.jobsDatabaseService, ticket, dataset.getProjectKey(), computedMetrics, metricsComputationTime);
        try (FutureProgress.AutocloseableFutureProgressState s = FutureProgress.pushAutoCloseableState((String)String.format("Computing rules on partition %s", partition.id()), (double)rulesToCompute.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            for (DataQualityRule rule : rulesToCompute) {
                MetricsComputationService.MetricsCheckRunReport runReport = new MetricsComputationService.MetricsCheckRunReport(partition.id(), rule.getId());
                try {
                    RuleValidationError validationError = rule.verifyConfig(dataset);
                    if (validationError == null) {
                        validationError = rule.verifyPreConditions(dataset, computedMetrics);
                    }
                    if (validationError != null) {
                        report.results.add(new AbstractValuedCheck.ValuedDataQualityRule(rule, new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, validationError.getMessage())));
                        continue;
                    }
                    report.results.add(new AbstractValuedCheck.ValuedDataQualityRule(rule, rule.run(user, context, runReport)));
                }
                catch (Exception ex) {
                    logger.error((Object)"Rule failed to run", (Throwable)ex);
                    runReport.handleException(ex);
                    report.results.add(new AbstractValuedCheck.ValuedDataQualityRule(rule, new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, ex.getLocalizedMessage())));
                }
                report.runs.add(runReport);
                FutureProgress.incrementState((double)1.0);
            }
            logger.info((Object)("Collected " + report.results.size() + " rule results"));
        }
        finally {
            this.apiTicketService.expireTicket(ticket);
        }
        if (!rulesToCompute.isEmpty() && options.saveRuleResult) {
            Map<DataQualityRule, AbstractCheckContext.CheckResult> results = report.results.stream().collect(Collectors.toMap(valuedDQRule -> valuedDQRule.check, valuedDQRule -> valuedDQRule.value));
            DatasetLocUtils.DatasetLoc datasetLoc = dataset.getLoc();
            this.metricsComputationService.saveChecksValues(datasetLoc.getProjectKey(), datasetLoc.getName(), partition, timeCheck, results, options.runOrigin);
            Map<Metric, String> metricsValues = results.entrySet().stream().collect(Collectors.toMap(entry -> new CheckProbeType.CheckMetric(CheckProbeType.CheckMetrics.CHECK, ((DataQualityRule)entry.getKey()).getId()), entry -> ((AbstractCheckContext.CheckResult)entry.getValue()).outcome.name()));
            this.metricsComputationService.saveMetricsValues(user, dataset, MetricTargetType.DATASET, partition, timeCheck, metricsValues, environment, false);
        }
        return report;
    }

    private ProbesSet getProbesSet(Dataset dataset, List<DataQualityRule> rules, boolean computeAllMetrics) {
        ProbesSet originalProbeSet = dataset.getModel().getMetrics();
        List<Probe> probes = rules.stream().filter(MetricsBasedDataQualityRule.class::isInstance).map(MetricsBasedDataQualityRule.class::cast).filter(rule -> ((DataQualityRule)((Object)rule)).verifyConfig(dataset) == null).flatMap(rule -> rule.getMetrics().stream().map(metric -> metric.getMatchingProbe(originalProbeSet.getProbes())).filter(Objects::nonNull).peek(probe -> {
            probe.enabled = true;
        }).peek(probe -> {
            probe.computeOnBuildMode = Probe.ComputeMode.BOTH;
        })).collect(Collectors.toList());
        ProbesSet res = new ProbesSet().withProbes(probes);
        res.engineConfig = originalProbeSet.engineConfig;
        if (computeAllMetrics) {
            res.probes.addAll(originalProbeSet.getProbes());
        }
        return res;
    }

    private boolean isDatasetSourceInFlow_NT(Dataset dataset) throws IOException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            ProjectFlowGraph graph = this.flowGraphService.getProjectGraphUnsafe(dataset.getProjectKey());
            FlowDataset fd = graph.getDataset(dataset.getProjectKey(), dataset.getName());
            if (fd == null) {
                this.flowGraphService.invalidateCache(dataset.getProjectKey());
                graph = this.flowGraphService.getProjectGraphUnsafe(dataset.getProjectKey());
                fd = graph.getDataset(dataset.getProjectKey(), dataset.getName());
            }
            boolean bl = fd == null || fd.getPredecessors().isEmpty();
            return bl;
        }
    }

    public static enum PartitionSelection {
        BOTH,
        PARTITION,
        WHOLE_DATASET;

    }

    public static class DataQualityRuleChecksReport {
        public List<MetricsComputationService.MetricsCheckRunReport> runs = Lists.newArrayList();
        public List<AbstractValuedCheck.ValuedDataQualityRule> results = new ArrayList<AbstractValuedCheck.ValuedDataQualityRule>();
    }
}

