/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.sampleio.SampleReader;
import com.dataiku.dip.shaker.server.AdditionalInputAccessor;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class MRAdditionalInputsLoader
implements AdditionalInputAccessor {
    private static Logger logger = Logger.getLogger((String)"dku.shaker.additional.mr");
    private final Map<String, File> localResourceFiles;

    public MRAdditionalInputsLoader(Map<String, File> localResourceFiles) {
        this.localResourceFiles = localResourceFiles;
    }

    @Override
    public StreamAdditionalInput getAdditionalInput(String name) throws Exception {
        logger.info((Object)("Trying to load additional input " + name));
        String id = "dku.shaker.dependency." + name;
        if (this.localResourceFiles.containsKey(id)) {
            return new StreamAdditionalInput(this.localResourceFiles.get(id));
        }
        throw new Exception("Failed to find additional input '" + name + "'");
    }

    public class StreamAdditionalInput
    implements AdditionalInputAccessor.AdditionalInput {
        private MemTable mt;

        public StreamAdditionalInput(File file) throws IOException {
            try (SampleReader reader = new SampleReader(file);){
                this.mt = reader.readAsMemtable();
            }
        }

        @Override
        public ColumnFactory getColumnFactory() {
            return this.mt;
        }

        @Override
        public RowInputStream getInput() throws Exception {
            return this.mt.stream();
        }
    }
}

