/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class SplitFold
extends SingleInputSingleOutputRowProcessor
implements Processor {
    private final Parameter parameter;
    public static final ProcessorMeta<SplitFold, Parameter> META = new ProcessorMeta<SplitFold, Parameter>(){

        @Override
        public String getName() {
            return "SplitFold";
        }

        @Override
        public String getDocPage() {
            return "split-fold";
        }

        @Override
        public Category getCategory() {
            return Category.RESHAPING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.SplitFold.DESCRIPTION", 1.actionVerb("Split") + " and " + 1.actionVerb("fold"))).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.COLUMN", "Column")).withMNESParam("separator", this.translate(language, "SHAKER.PROCESSOR.JSONFlattener.DESCRIPTION.SEPARATOR", "Separator")).withBool("keepEmptyChunks", this.translate(language, "SHAKER.PROCESSOR.SplitFold.DESCRIPTION.KEEP_EMPTY_CHUNKS", "Keep empty chunks")).withBoolDefaultTrue("trimSpaces", this.translate(language, "SHAKER.PROCESSOR.SplitFold.DESCRIPTION.TRIM_SPACES", "Trim spaces"));
        }

        @Override
        public Object selfReport(Parameter p) {
            return JSON.deepCopyExcept((Object)p, (String[])new String[]{"column"});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.SplitFold.HELP", "This processor splits the values of a column based on a separator and transforms them into several rows.");
        }

        @Override
        public SplitFold build(Parameter parameter) throws Exception {
            return new SplitFold(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            return previousRecipeLineage;
        }
    };
    private Column foldCD;

    public SplitFold(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() {
        this.foldCD = this.getCf().column(this.parameter.column, Processor.ProcessorRole.INPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        String v = row.get(this.foldCD);
        if (v == null || v.isEmpty()) {
            return;
        }
        String[] chunks = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)v, (String)this.parameter.separator);
        if (chunks.length == 1) {
            this.getProcessorOutput().emitRow(row);
            return;
        }
        for (String chunk : chunks) {
            if (!this.parameter.keepEmptyChunks && chunk.length() <= 0) continue;
            Row newRow = this.getRf().row();
            for (Column c2 : this.getCf().columns()) {
                String colVal = row.get(c2);
                if (StringUtils.isBlank((String)colVal)) continue;
                newRow.put(c2, colVal);
            }
            chunk = this.parameter.trimSpaces ? chunk.trim() : chunk;
            newRow.put(this.foldCD, chunk);
            this.getProcessorOutput().emitRow(newRow);
        }
    }

    public void postProcess() throws Exception {
        this.getProcessorOutput().lastRowEmitted();
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        String column;
        String separator;
        boolean keepEmptyChunks;
        boolean trimSpaces;

        public void validate() throws IllegalArgumentException {
        }
    }
}

