/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ZipArraysProcessor
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<ZipArraysProcessor, Parameter> META = new ProcessorMeta<ZipArraysProcessor, Parameter>(){

        @Override
        public String getName() {
            return "ZipArrays";
        }

        @Override
        public String getDocPage() {
            return "zip-arrays";
        }

        @Override
        public Category getCategory() {
            return Category.RESHAPING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING, ProcessorTag.COMPLEX});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.ZipArraysProcessor.HELP", "This processor combines N input columns containing arrays (as JSON) into a single output column.\n\nThe output column will contain JSON arrays of objects.\n\n# Example\n\n* Input:\n\n```\n   a       b\n   [1,2]   [\"x\",\"y\"]\n```\n*  Output:\n\n```\n   [{\"a\":1, \"b\":\"x\"} , {\"a\":2, \"b\":\"y\"}]\n```\n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.ZipArraysProcessor.DESCRIPTION", 1.actionVerb("Zip") + " JSON arrays")).withParam(new ParamDesc("inputColumns", "columns").withLabel(this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.INPUT_COLUMNS", "Input columns"))).withMNESParam("outputColumn", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN", "Output column"));
        }

        @Override
        public Object selfReport(Parameter p) {
            JsonObject out = new JsonObject();
            out.addProperty("nbInputColumns", (Number)p.inputColumns.size());
            return out;
        }

        @Override
        public ZipArraysProcessor build(Parameter parameter) throws Exception {
            return new ZipArraysProcessor(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter params = (Parameter)pss.params;
            if (params.inputColumns.isEmpty()) {
                throw new IllegalConfigurationException("Missing input columns for Zip JSON arrays processor");
            }
            if (StringUtils.isBlank((String)params.outputColumn)) {
                throw new IllegalConfigurationException("Missing output column for Zip JSON arrays processor");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                params.inputColumns.forEach(inputColumn -> updatedDatasetPairLineage.addFactorizedColumnRelations((String)inputColumn, params.outputColumn));
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    Parameter parameter;
    private List<Column> inputColumns = new ArrayList<Column>();
    private Column outputColumn;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.json");

    public ZipArraysProcessor(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() {
        for (String col : this.parameter.inputColumns) {
            this.inputColumns.add(this.getColumnFactory().column(col, Processor.ProcessorRole.INPUT_COLUMN));
        }
        this.outputColumn = this.getColumnFactory().column(this.parameter.outputColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        try {
            ArrayList<JSONArray> inputs = new ArrayList<JSONArray>();
            for (int i = 0; i < this.inputColumns.size(); ++i) {
                String v = row.get(this.inputColumns.get(i));
                if (v != null && !v.isEmpty()) {
                    inputs.add(new JSONArray(v));
                    continue;
                }
                inputs.add(new JSONArray());
            }
            int maxLen = 0;
            for (JSONArray arr : inputs) {
                maxLen = Math.max(maxLen, arr.length());
            }
            ArrayList<JSONObject> out = new ArrayList<JSONObject>();
            for (int i = 0; i < maxLen; ++i) {
                JSONObject o = new JSONObject();
                for (int j = 0; j < this.inputColumns.size(); ++j) {
                    if (i >= ((JSONArray)inputs.get(j)).length()) continue;
                    o.put(this.inputColumns.get(j).getName(), ((JSONArray)inputs.get(j)).get(i));
                }
                out.add(o);
            }
            row.put(this.outputColumn, ((Object)out).toString());
        }
        catch (Exception e) {
            this.warningsContext.addWarning(WarningsContext.WarningType.INPUT_DATA_BAD_DATA, "Failed to parse JSON", (Throwable)e, logger);
        }
    }

    public void postProcess() throws Exception {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public List<String> inputColumns = new ArrayList<String>();
        public String outputColumn;

        public void validate() throws IllegalArgumentException {
        }
    }
}

