/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class SimpleSelectQueryBuilder {
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    private boolean distinct;
    private final List<String> columns = new ArrayList<String>();
    private final boolean selectAll;
    private SQLUtils.SQLTable table;
    private String as;
    private String orderingColumn;
    private QueryAst.OrderType forcedOrderType;
    private LimitType limitType;
    private List<ExpressionBuilder> wheres = new ArrayList<ExpressionBuilder>();

    private SimpleSelectQueryBuilder(boolean selectAll) {
        this.selectAll = selectAll;
        this.limitType = LimitType.NONE;
    }

    public static SimpleSelectQueryBuilder select() {
        return new SimpleSelectQueryBuilder(false);
    }

    public static SimpleSelectQueryBuilder selectAll() {
        return new SimpleSelectQueryBuilder(true);
    }

    public static SimpleSelectQueryBuilder select(String column) {
        return SimpleSelectQueryBuilder.select().column(column);
    }

    public SimpleSelectQueryBuilder column(String column) {
        this.columns.add(column);
        return this;
    }

    public SimpleSelectQueryBuilder distinct() {
        this.distinct = true;
        return this;
    }

    public SimpleSelectQueryBuilder columns(SchemaColumn[] ... schemaColumnList) {
        SchemaColumn[][] schemaColumnArray = schemaColumnList;
        int n = schemaColumnArray.length;
        for (int i = 0; i < n; ++i) {
            SchemaColumn[] schemaColumns;
            for (SchemaColumn schemaColumn : schemaColumns = schemaColumnArray[i]) {
                this.columns.add(schemaColumn.getName());
            }
        }
        return this;
    }

    public SimpleSelectQueryBuilder from(SQLUtils.SQLTable table, String as) {
        this.table = table;
        this.as = as;
        return this;
    }

    public SimpleSelectQueryBuilder from(SQLUtils.SQLTable table) {
        this.table = table;
        this.as = table.getTable();
        return this;
    }

    public SimpleSelectQueryBuilder wheres(String ... wheres) {
        for (String where : wheres) {
            this.wheres.add(EBF.parameterizedColumnOperation(where, QueryUtils.OperatorType.NULL_UNSAFE_EQ));
        }
        return this;
    }

    public SimpleSelectQueryBuilder where(ExpressionBuilder where) {
        this.wheres.add(where);
        return this;
    }

    public SimpleSelectQueryBuilder orderedBy(String column) {
        this.orderingColumn = column;
        return this;
    }

    public SimpleSelectQueryBuilder ascending() {
        this.forcedOrderType = QueryAst.OrderType.ASC;
        return this;
    }

    public SimpleSelectQueryBuilder descending() {
        this.forcedOrderType = QueryAst.OrderType.DESC;
        return this;
    }

    public SimpleSelectQueryBuilder first() {
        this.limitType = LimitType.FIRST;
        return this;
    }

    public SimpleSelectQueryBuilder last() {
        this.limitType = LimitType.LAST;
        return this;
    }

    public SimpleSelectQueryBuilder withParameterizedMax() {
        this.limitType = LimitType.WITH_PARAMETERIZED_MAX;
        return this;
    }

    public String toSQL(SQLDialect dialect) {
        Preconditions.checkNotNull((Object)this.table, (Object)"A table name must be specified.");
        if (this.selectAll) {
            Preconditions.checkState((boolean)this.columns.isEmpty(), (Object)"No column must be specified in 'select all' mode.");
        }
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        if (this.distinct) {
            sqb.selectDistinct();
        }
        sqb.from(this.table, this.as);
        if (this.selectAll) {
            sqb.select("*");
        } else {
            for (String column : this.columns) {
                sqb.select(column);
            }
        }
        this.appendWhereExpression(sqb);
        return this.appendOrderAndLimit(sqb, dialect);
    }

    private void appendWhereExpression(SelectQueryBuilder sqb) {
        if (this.wheres == null) {
            return;
        }
        ExpressionBuilder whereExpressionBuilder = null;
        for (ExpressionBuilder expressionBuilder : this.wheres) {
            if (whereExpressionBuilder == null) {
                whereExpressionBuilder = expressionBuilder;
                continue;
            }
            whereExpressionBuilder = whereExpressionBuilder.and(expressionBuilder);
        }
        sqb.where(whereExpressionBuilder);
    }

    private String appendOrderAndLimit(SelectQueryBuilder sqb, SQLDialect dialect) {
        if (this.orderingColumn == null) {
            Preconditions.checkState((boolean)LimitType.NONE.equals((Object)this.limitType), (Object)"Cannot define a limit if no ordering column is specified.");
            return sqb.toSQL(dialect);
        }
        QueryAst.OrderType orderType = this.forcedOrderType;
        return sqb.order(this.orderingColumn, orderType).toSQL(dialect) + (switch (this.limitType) {
            case LimitType.FIRST -> {
                this.checkNoForcedOrder();
                orderType = QueryAst.OrderType.ASC;
                yield " LIMIT 1";
            }
            case LimitType.LAST -> {
                this.checkNoForcedOrder();
                orderType = QueryAst.OrderType.DESC;
                yield " LIMIT 1";
            }
            case LimitType.WITH_PARAMETERIZED_MAX -> " LIMIT ? OFFSET ?";
            default -> "";
        });
    }

    private void checkNoForcedOrder() {
        Preconditions.checkState((this.forcedOrderType == null ? 1 : 0) != 0, (Object)String.format("Order type must not be forced when selecting %s", this.limitType.name()));
    }

    public static enum LimitType {
        FIRST,
        LAST,
        WITH_PARAMETERIZED_MAX,
        NONE;

    }
}

