/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sqlnotebooks;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import java.util.List;

public class SQLNotebookQuery {
    public QueryMode mode;
    public String id;
    public long runOn;
    public long runIn = -1L;
    public String runBy;
    public String connection;
    public JobState state = JobState.NOT_STARTED;
    public String futureId;
    public String hash;
    public String hiveQueryId;
    public QuerySettings querySettings = new QuerySettings();
    private String sql;
    private String expandedSql;

    public String getExpandedSql(VariablesContext vc) {
        this.expandedSql = vc.expand(this.sql);
        return this.expandedSql;
    }

    public String getUnexpandedSQL() {
        return this.sql;
    }

    public void updateUnexpandedSQL(String updatedSQL) {
        this.sql = updatedSQL;
    }

    public static class QuerySettings {
        public boolean addLimitToStatement = true;
        public boolean statementsOutOfTransaction;
        public String inheritConf = "default";
        public List<SimpleKeyValue> extraConf = Lists.newArrayList();
        public boolean addDkuUdf = false;
        public QueryStatementsParsingMode statementsParseMode = QueryStatementsParsingMode.SPLIT;
        public QueryStatementsExecutionMode statementsExecutionMode = QueryStatementsExecutionMode.PREPARED;
    }

    public static enum QueryStatementsExecutionMode {
        PREPARED,
        UNPREPARED;

    }

    public static enum QueryStatementsParsingMode {
        SPLIT,
        RAW;

    }

    public static enum QueryMode {
        SQL,
        HIVE;

    }
}

