/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.kafka;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.streaming.ksql.KsqlRESTClient;
import com.dataiku.dip.streaming.endpoints.StringBasedFormats;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatDeserializer;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatSerializer;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class SingleValueKafkaFormat {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.kafka");

    public static class SingleValueKafkaFormatSerializer
    implements KafkaFormatSerializer {
        private final SingleValueKafkaFormatParams params;
        private StringBasedFormats.SingleValueFormatSerializer serializer;
        private int errorCount = 0;

        public SingleValueKafkaFormatSerializer(SingleValueKafkaFormatParams params) {
            this.params = params;
        }

        @Override
        public void init(ColumnFactory cf, Schema schema) {
            this.serializer = new StringBasedFormats.SingleValueFormatSerializer(cf, this.params.columnName);
        }

        @Override
        public String getKafkaSerializer() {
            switch (this.params.columnType) {
                case DOUBLE: {
                    return DoubleSerializer.class.getCanonicalName();
                }
                case LONG: {
                    return LongSerializer.class.getCanonicalName();
                }
                case INTEGER: {
                    return IntegerSerializer.class.getCanonicalName();
                }
                case BYTEARRAY: {
                    return ByteArraySerializer.class.getCanonicalName();
                }
                case STRING: {
                    return StringSerializer.class.getCanonicalName();
                }
            }
            throw new Error("unreachable");
        }

        @Override
        public Object serialize(Row row) {
            Object typed;
            if (StringUtils.isBlank((String)this.params.columnName)) {
                return null;
            }
            String v = this.serializer.serialize(row);
            try {
                switch (this.params.columnType) {
                    case DOUBLE: {
                        typed = StringUtils.isBlank((String)v) ? null : Double.valueOf(Double.parseDouble(v));
                        break;
                    }
                    case LONG: {
                        typed = StringUtils.isBlank((String)v) ? null : Long.valueOf(Long.parseLong(v));
                        break;
                    }
                    case INTEGER: {
                        typed = StringUtils.isBlank((String)v) ? null : Integer.valueOf(Integer.parseInt(v));
                        break;
                    }
                    case STRING: {
                        typed = v;
                        break;
                    }
                    case BYTEARRAY: {
                        typed = StringUtils.isBlank((String)v) ? null : Base64.decodeBase64((String)v);
                        break;
                    }
                    default: {
                        throw new Error("unreachable");
                    }
                }
            }
            catch (Exception e) {
                ++this.errorCount;
                if (this.errorCount < 10) {
                    logger.error((Object)("Failed to serialize " + v), (Throwable)e);
                }
                typed = null;
            }
            return typed;
        }

        @Override
        public List<String> columnNamesForSchema(Schema schema) {
            return this.params.columnNamesForSchema(schema);
        }

        @Override
        public List<SchemaColumn> getSchemaColumns(Schema schema) {
            return this.params.getSchemaColumns(schema);
        }
    }

    public static class SingleValueKafkaFormatDeserializer
    implements KafkaFormatDeserializer {
        private final SingleValueKafkaFormatParams params;
        private StringBasedFormats.SingleValueFormatDeserializer deserializer;

        public SingleValueKafkaFormatDeserializer(SingleValueKafkaFormatParams params) {
            this.params = params;
        }

        @Override
        public void init(ColumnFactory cf, RowFactory rf, Schema schema) {
            this.deserializer = new StringBasedFormats.SingleValueFormatDeserializer(cf, this.params.columnName);
        }

        @Override
        public String getKafkaDeserializer() {
            switch (this.params.columnType) {
                case DOUBLE: {
                    return DoubleDeserializer.class.getCanonicalName();
                }
                case LONG: {
                    return LongDeserializer.class.getCanonicalName();
                }
                case INTEGER: {
                    return IntegerDeserializer.class.getCanonicalName();
                }
                case BYTEARRAY: {
                    return ByteArrayDeserializer.class.getCanonicalName();
                }
                case STRING: {
                    return StringDeserializer.class.getCanonicalName();
                }
            }
            throw new Error("unreachable");
        }

        @Override
        public void deserialize(Object v, Row row) {
            if (StringUtils.isBlank((String)this.params.columnName)) {
                return;
            }
            this.deserializer.deserialize(switch (this.params.columnType) {
                case KeyType.DOUBLE -> {
                    Double typed = (Double)v;
                    yield typed == null ? "" : Double.toString(typed);
                }
                case KeyType.LONG -> {
                    Long typed = (Long)v;
                    yield typed == null ? "" : Long.toString(typed);
                }
                case KeyType.INTEGER -> {
                    Integer typed = (Integer)v;
                    yield typed == null ? "" : Integer.toString(typed);
                }
                case KeyType.STRING -> {
                    String typed;
                    yield typed = (String)v;
                }
                case KeyType.BYTEARRAY -> {
                    byte[] typed = (byte[])v;
                    yield typed == null ? "" : Base64.encodeBase64String((byte[])typed);
                }
                default -> throw new Error("unreachable");
            }, row);
        }

        @Override
        public List<String> columnNamesForSchema(Schema schema) {
            return this.params.columnNamesForSchema(schema);
        }

        @Override
        public List<SchemaColumn> getSchemaColumns(Schema schema) {
            return this.params.getSchemaColumns(schema);
        }

        @Override
        public Schema fetchSchema(Properties props, String topic, boolean isKey) {
            Schema schema = new Schema();
            if (StringUtils.isBlank((String)this.params.columnName)) {
                return schema;
            }
            switch (this.params.columnType) {
                case BYTEARRAY: 
                case STRING: {
                    schema.addColumn(StringUtils.defaultIfBlank((String)this.params.columnName, (String)"ROWKEY"), Type.STRING);
                    break;
                }
                case DOUBLE: {
                    schema.addColumn(StringUtils.defaultIfBlank((String)this.params.columnName, (String)"ROWKEY"), Type.DOUBLE);
                    break;
                }
                case INTEGER: {
                    schema.addColumn(StringUtils.defaultIfBlank((String)this.params.columnName, (String)"ROWKEY"), Type.INT);
                    break;
                }
                case LONG: {
                    schema.addColumn(StringUtils.defaultIfBlank((String)this.params.columnName, (String)"ROWKEY"), Type.BIGINT);
                }
            }
            return schema;
        }
    }

    public static class SingleValueKafkaFormatParams {
        public String columnName;
        public KeyType columnType = KeyType.BYTEARRAY;

        private List<SchemaColumn> getSchemaColumns(Schema schema) {
            if (StringUtils.isBlank((String)this.columnName)) {
                return Lists.newArrayList();
            }
            SchemaColumn sc = schema.getColumn(this.columnName);
            if (sc != null) {
                return Lists.newArrayList((Object[])new SchemaColumn[]{sc});
            }
            return Lists.newArrayList((Object[])new SchemaColumn[]{new SchemaColumn(this.columnName, this.columnType.dssType())});
        }

        private List<String> columnNamesForSchema(Schema schema) {
            ArrayList ret = Lists.newArrayList();
            if (StringUtils.isNotBlank((String)this.columnName)) {
                ret.add(this.columnName);
            }
            return ret;
        }
    }

    public static enum KeyType {
        STRING(Type.STRING, KsqlRESTClient.KsqlFieldType.STRING),
        LONG(Type.BIGINT, KsqlRESTClient.KsqlFieldType.BIGINT),
        DOUBLE(Type.DOUBLE, KsqlRESTClient.KsqlFieldType.DOUBLE),
        INTEGER(Type.INT, KsqlRESTClient.KsqlFieldType.INTEGER),
        BYTEARRAY(Type.STRING, null);

        private final Type dssType;
        private final KsqlRESTClient.KsqlFieldType ksqlType;

        private KeyType(Type dssType, KsqlRESTClient.KsqlFieldType ksqlType) {
            this.dssType = dssType;
            this.ksqlType = ksqlType;
        }

        public Type dssType() {
            return this.dssType;
        }

        public KsqlRESTClient.KsqlFieldType ksqlType() {
            return this.ksqlType;
        }

        public static KeyType fromDssType(Type dssType) {
            for (KeyType e : KeyType.values()) {
                if (e.dssType != dssType) continue;
                return e;
            }
            return null;
        }

        public static KeyType fromKsqlType(KsqlRESTClient.KsqlFieldType ksqlType) {
            for (KeyType e : KeyType.values()) {
                if (e.ksqlType != ksqlType) continue;
                return e;
            }
            return null;
        }
    }
}

