/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.sqs;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointMeta;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointService;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePuller;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleWriter;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.streaming.endpoints.sqs.SQSSimplePuller;
import com.dataiku.dip.streaming.endpoints.sqs.SQSStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.sqs.ToSQSStreamer;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class SQSStreamingEndpointMeta
extends StreamingEndpointMeta {
    public static final String TYPE = "sqs";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Class<? extends StreamingEndpoint.StreamingEndpointParams> paramsClass() {
        return SQSStreamingEndpointParams.class;
    }

    @Override
    public StreamingEndpointSimpleWriter getSimpleWriter(AuthCtx authCtx, StreamingEndpoint targetSE, ColumnFactory cf, WarningsContext warningsContext) throws Exception {
        return new ToSQSStreamer(authCtx, targetSE, cf, warningsContext);
    }

    @Override
    public StreamingEndpointSimplePuller getSimplePuller(AuthCtx authCtx, StreamingEndpoint sourceSE, boolean nonConsuming) {
        return new SQSSimplePuller(authCtx, this.getExpandedParams(sourceSE.projectKey, sourceSE, SQSStreamingEndpointParams.class), nonConsuming);
    }

    @Override
    public void fillManagedParams(StreamingEndpoint se, DSSConnection connection, String formatOptionId) {
        SQSStreamingEndpointParams params = se.getParamsAs(SQSStreamingEndpointParams.class);
        params.queueName = "${projectKey}-${seId}";
        params.formatType = StringUtils.defaultIfBlank((String)formatOptionId, (String)"json").toLowerCase();
        params.connection = connection.name;
    }

    @Override
    public void fillCopyParams(StreamingEndpoint se) {
        SQSStreamingEndpointParams params = se.getParamsAs(SQSStreamingEndpointParams.class);
        params.queueName = "${projectKey}-${seId}";
    }

    @Override
    public void checkUsability(AuthCtx authCtx, StreamingEndpoint se) throws DKUSecurityException, IOException {
        DSSConnection connection;
        SQSStreamingEndpointParams params = se.getParamsAs(SQSStreamingEndpointParams.class);
        if (!StringUtils.isBlank((String)params.connection) && (connection = ConnectionsDAO.get().getConnectionUnsafeUnexpanded(authCtx, params.connection)) != null && !connection.isFreelyUsableBy(authCtx)) {
            throw new DKUSecurityException("User is not allowed to access connection " + params.connection);
        }
    }

    @Override
    public <T extends StreamingEndpoint.StreamingEndpointParams> T getExpandedParams(String projectKey, StreamingEndpoint se, Class<T> clazz) {
        SQSStreamingEndpointParams params = (SQSStreamingEndpointParams)JSON.deepCopy((Object)se.getParamsAs(SQSStreamingEndpointParams.class));
        VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForProject(projectKey);
        vc.add("projectKey", se.projectKey);
        vc.add("seId", se.id);
        params.queueName = vc.expand(params.queueName);
        return (T)((StreamingEndpoint.StreamingEndpointParams)clazz.cast(params));
    }

    @Override
    public StreamingEndpoint create(StreamingEndpointService.StreamingEndpointProto proto) throws InstantiationException, IllegalAccessException {
        StreamingEndpoint se = super.create(proto);
        se.getParamsAs(SQSStreamingEndpointParams.class).connection = proto.connection;
        return se;
    }
}

