/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines.workspace;

import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.timelines.workspace.IWorkspaceTimelinesDBService;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelineBehavior;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelineItem;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelinesService;

public abstract class AbstractWorkspaceTimelinesService
implements IWorkspaceTimelinesDBService {
    @Override
    public DSSDBConnection acquireConnection(String workspaceKey) throws CodedSQLException {
        return this.acquireConnection(workspaceKey, false);
    }

    @Override
    public void insert(WorkspaceTimelineItem ti) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection(ti.workspaceKey);){
            this.getDao(ti.workspaceKey).insert(conn, ti);
        }
    }

    @Override
    public void update(WorkspaceTimelineItem ti) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection(ti.workspaceKey);){
            this.getDao(ti.workspaceKey).update(conn, ti);
        }
    }

    @Override
    public WorkspaceTimelinesService.WorkspaceTimelineWithVersioning getForWorkspace(String workspaceKey, int from, int limit) throws CodedSQLException {
        WorkspaceTimelineBehavior dao = this.getDao(workspaceKey);
        try (DSSDBConnection connection = this.acquireConnection(workspaceKey);){
            WorkspaceTimelinesService.WorkspaceTimelineWithVersioning workspaceTimelineWithVersioning = dao.getForWorkspace(connection, from, limit);
            return workspaceTimelineWithVersioning;
        }
    }

    @Override
    public WorkspaceTimelineItem getFirstForObject(String workspaceKey, ITaggingService.TaggableType objectType, String projectKey, String objectId) throws CodedSQLException {
        WorkspaceTimelineBehavior dao = this.getDao(workspaceKey);
        try (DSSDBConnection connection = this.acquireConnection(workspaceKey);){
            WorkspaceTimelineItem workspaceTimelineItem = dao.getFirstForObject(connection, objectType, projectKey, objectId);
            return workspaceTimelineItem;
        }
    }

    @Override
    public WorkspaceTimelineItem getLatestForObject(String workspaceKey, ITaggingService.TaggableType objectType, String projectKey, String objectId) throws CodedSQLException {
        WorkspaceTimelineBehavior dao = this.getDao(workspaceKey);
        try (DSSDBConnection conn = this.acquireConnection(workspaceKey);){
            WorkspaceTimelineItem workspaceTimelineItem = dao.getLatestForObject(conn, objectType, projectKey, objectId);
            return workspaceTimelineItem;
        }
    }

    @Override
    public WorkspaceTimelineItem getLatestForUser(String workspaceKey, String userId) throws CodedSQLException {
        WorkspaceTimelineBehavior dao = this.getDao(workspaceKey);
        try (DSSDBConnection conn = this.acquireConnection(workspaceKey);){
            WorkspaceTimelineItem workspaceTimelineItem = dao.getLatestForUser(conn, userId);
            return workspaceTimelineItem;
        }
    }

    @Override
    public WorkspaceTimelineItem getLatest(String workspaceKey) throws CodedSQLException {
        WorkspaceTimelineBehavior dao = this.getDao(workspaceKey);
        try (DSSDBConnection conn = this.acquireConnection(workspaceKey);){
            WorkspaceTimelineItem workspaceTimelineItem = dao.getLatest(conn);
            return workspaceTimelineItem;
        }
    }
}

