/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring.settings;

import com.dataiku.dip.dao.UnifiedMonitoringBatchIntervalsDTO;
import com.dataiku.dip.dao.UnifiedMonitoringSettings;
import com.dataiku.dip.dao.UnifiedMonitoringSettingsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringBatchFrequencyChangedEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringEndpointInfrastructureDisabledEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringEndpointInfrastructureEnabledEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringExternalEndpointsScopeCreatedEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringExternalEndpointsScopeDeletedEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringExternalEndpointsScopeDisabledEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringExternalEndpointsScopeEnabledEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.UnifiedMonitoringExternalEndpointsScope;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedMonitoringSettingsService {
    @Autowired
    private UnifiedMonitoringSettingsDAO unifiedMonitoringSettingsDAO;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TransactionService transactionService;

    public void save(AuthCtx user, UnifiedMonitoringSettings newUnifiedMonitoringSettings) throws Exception {
        UnifiedMonitoringSettings oldUnifiedMonitoringSettings;
        try (Transaction t = this.transactionService.beginRead();){
            oldUnifiedMonitoringSettings = this.unifiedMonitoringSettingsDAO.read();
        }
        newUnifiedMonitoringSettings.validate();
        t = this.transactionService.beginWriteAsLoggedInUser(user);
        try {
            if (newUnifiedMonitoringSettings.endpointsBatchFrequencyInMinutes != oldUnifiedMonitoringSettings.endpointsBatchFrequencyInMinutes) {
                this.pubSub.publishAfterTransaction((DSSEvent)new UnifiedMonitoringBatchFrequencyChangedEvent.UnifiedMonitoringEndpointsBatchFrequencyChangedEvent(newUnifiedMonitoringSettings.endpointsBatchFrequencyInMinutes));
            }
            if (newUnifiedMonitoringSettings.systemMetricsBatchFrequencyInSeconds != oldUnifiedMonitoringSettings.systemMetricsBatchFrequencyInSeconds) {
                this.pubSub.publishAfterTransaction((DSSEvent)new UnifiedMonitoringBatchFrequencyChangedEvent.UnifiedMonitoringSystemMetricsBatchFrequencyChangedEvent(newUnifiedMonitoringSettings.systemMetricsBatchFrequencyInSeconds));
            }
            if (newUnifiedMonitoringSettings.projectsBatchFrequencyInMinutes != oldUnifiedMonitoringSettings.projectsBatchFrequencyInMinutes) {
                this.pubSub.publishAfterTransaction((DSSEvent)new UnifiedMonitoringBatchFrequencyChangedEvent.UnifiedMonitoringProjectsBatchFrequencyChangedEvent(newUnifiedMonitoringSettings.projectsBatchFrequencyInMinutes));
            }
            for (UnifiedMonitoringExternalEndpointsScope externalEndpointsScope : oldUnifiedMonitoringSettings.externalEndpointsScopes) {
                if (newUnifiedMonitoringSettings.externalEndpointsScopes.contains(externalEndpointsScope)) continue;
                this.pubSub.publishAfterTransaction((DSSEvent)new UnifiedMonitoringExternalEndpointsScopeDeletedEvent(externalEndpointsScope.name));
            }
            for (UnifiedMonitoringExternalEndpointsScope externalEndpointsScope : newUnifiedMonitoringSettings.externalEndpointsScopes) {
                if (oldUnifiedMonitoringSettings.externalEndpointsScopes.contains(externalEndpointsScope)) continue;
                this.pubSub.publishAfterTransaction((DSSEvent)new UnifiedMonitoringExternalEndpointsScopeCreatedEvent(externalEndpointsScope.name));
            }
            for (String infrastructureId : newUnifiedMonitoringSettings.unmonitoredEndpointInfrastructures) {
                if (oldUnifiedMonitoringSettings.unmonitoredEndpointInfrastructures.contains(infrastructureId)) continue;
                this.pubSub.publishAfterTransaction((DSSEvent)new UnifiedMonitoringEndpointInfrastructureDisabledEvent(infrastructureId));
            }
            for (String infrastructureId : oldUnifiedMonitoringSettings.unmonitoredEndpointInfrastructures) {
                if (newUnifiedMonitoringSettings.unmonitoredEndpointInfrastructures.contains(infrastructureId)) continue;
                this.pubSub.publishAfterTransaction((DSSEvent)new UnifiedMonitoringEndpointInfrastructureEnabledEvent(infrastructureId));
            }
            for (String scopeName : newUnifiedMonitoringSettings.unmonitoredExternalEndpointsScopes) {
                if (oldUnifiedMonitoringSettings.unmonitoredExternalEndpointsScopes.contains(scopeName)) continue;
                this.pubSub.publishAfterTransaction((DSSEvent)new UnifiedMonitoringExternalEndpointsScopeDisabledEvent(scopeName));
            }
            for (String scopeName : oldUnifiedMonitoringSettings.unmonitoredExternalEndpointsScopes) {
                if (newUnifiedMonitoringSettings.unmonitoredExternalEndpointsScopes.contains(scopeName)) continue;
                this.pubSub.publishAfterTransaction((DSSEvent)new UnifiedMonitoringExternalEndpointsScopeEnabledEvent(scopeName));
            }
            this.unifiedMonitoringSettingsDAO.save(newUnifiedMonitoringSettings);
            t.commit("New unified monitoring settings persisted.");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    public UnifiedMonitoringSettings get() throws IOException {
        UnifiedMonitoringSettings unifiedMonitoringSettings;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            unifiedMonitoringSettings = this.unifiedMonitoringSettingsDAO.read();
        }
        return unifiedMonitoringSettings;
    }

    public UnifiedMonitoringBatchIntervalsDTO getBatchIntervalsDto() throws IOException {
        UnifiedMonitoringSettings unifiedMonitoringSettings = this.get();
        return new UnifiedMonitoringBatchIntervalsDTO(unifiedMonitoringSettings.systemMetricsBatchFrequencyInSeconds, unifiedMonitoringSettings.endpointsBatchFrequencyInMinutes);
    }
}

