/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonOrgJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.JsonOrgMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.Properties;
import org.json.JSONObject;

public class GetPath
implements Function {
    private ParseContext gsonContext = JsonPath.using((Configuration)Configuration.builder().mappingProvider((MappingProvider)new GsonMappingProvider()).jsonProvider((JsonProvider)new GsonJsonProvider()).build());
    private ParseContext jsonContext = JsonPath.using((Configuration)Configuration.builder().mappingProvider((MappingProvider)new JsonOrgMappingProvider()).jsonProvider((JsonProvider)new JsonOrgJsonProvider()).build());

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length > 1 && args.length <= 3) {
            Object v = args[0];
            Object pathExpr = args[1];
            if (v != null && pathExpr instanceof String) {
                try {
                    DocumentContext doc;
                    if (v instanceof String) {
                        doc = this.gsonContext.parse((String)v);
                    } else if (v instanceof JSONObject) {
                        doc = this.jsonContext.parse(v);
                    } else if (v instanceof JsonObject) {
                        doc = this.gsonContext.parse(v);
                    } else if (v instanceof JsonPrimitive) {
                        doc = this.gsonContext.parse(((JsonPrimitive)v).getAsString());
                    } else {
                        return null;
                    }
                    Object o = doc.read((String)pathExpr, new Predicate[0]);
                    if (o == null && args.length > 2) {
                        return args[2];
                    }
                    return o;
                }
                catch (Exception e) {
                    if (args.length > 2) {
                        return args[2];
                    }
                    return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " failed to evaluate " + (String)pathExpr + ". " + e.getMessage());
                }
            }
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.GetPath.DOCUMENTATION", "Evaluates the JsonPath path on the object <code>o</code> and returns the result when defined or <code>defaultValue</code>.").withParams("json o, string path, [defaultValue]").withReturns("GREL.FUNCTIONS.RETURNS.DEPENDS_ON_ARGUMENTS", "depends on arguments").withCategory("GREL.FUNCTIONS.CATEGORY.ARRAY", "Array functions");
    }
}

