/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.date;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.MutableDateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class DateTrunc
implements Function {
    private final DKUFormulaUtils formulaUtils = new DKUFormulaUtils();

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2 && args[0] != null && DKUFormulaUtils.isNotABlankString(args[0])) {
            if (args[1] instanceof String && StringUtils.isNotBlank((String)((String)args[1]))) {
                Object dt = this.formulaUtils.asTemporal(args[0], bindings);
                try {
                    DateUnit unit = this.convertUnit((String)args[1]);
                    if (dt instanceof DateTime) {
                        return DateTrunc.truncate((ReadableInstant)((DateTime)dt), unit);
                    }
                    if (dt instanceof LocalDate) {
                        return DateTrunc.truncate((ReadableInstant)((LocalDate)dt).toDateTimeAtStartOfDay(DateTimeZone.UTC), unit).toLocalDate();
                    }
                    if (dt instanceof LocalDateTime) {
                        return DateTrunc.truncate((ReadableInstant)((LocalDateTime)dt).toDateTime(DateTimeZone.UTC), unit).toLocalDateTime();
                    }
                }
                catch (IllegalArgumentException e) {
                    return new EvalError(e.getMessage());
                }
            }
            return null;
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a date and a string");
    }

    public static DateTime truncate(ReadableInstant ts, DateUnit unit) {
        MutableDateTime d = new MutableDateTime((Object)ts, DateTimeZone.UTC);
        d.setMillisOfSecond(0);
        switch (unit) {
            case YEARS: {
                d.setSecondOfMinute(0);
                d.setMinuteOfHour(0);
                d.setHourOfDay(0);
                d.setDayOfMonth(1);
                d.setMonthOfYear(1);
                break;
            }
            case QUARTERS: {
                d.setSecondOfMinute(0);
                d.setMinuteOfHour(0);
                d.setHourOfDay(0);
                d.setDayOfMonth(1);
                int i = (d.getMonthOfYear() - 1) / 3 * 3 + 1;
                d.setMonthOfYear(i);
                break;
            }
            case MONTHS: {
                d.setSecondOfMinute(0);
                d.setMinuteOfHour(0);
                d.setHourOfDay(0);
                d.setDayOfMonth(1);
                break;
            }
            case WEEKS: {
                d.setSecondOfMinute(0);
                d.setMinuteOfHour(0);
                d.setHourOfDay(0);
                d.setDayOfWeek(1);
                break;
            }
            case DAYS: {
                d.setSecondOfMinute(0);
                d.setMinuteOfHour(0);
                d.setHourOfDay(0);
                break;
            }
            case HOURS: {
                d.setSecondOfMinute(0);
                d.setMinuteOfHour(0);
                break;
            }
            case MINUTES: {
                d.setSecondOfMinute(0);
                break;
            }
            case SECONDS: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown date unit: " + String.valueOf((Object)unit));
            }
        }
        return d.toDateTime();
    }

    public DateUnit convertUnit(String part) {
        if ("hours".equals(part) || "hour".equals(part) || "h".equals(part)) {
            return DateUnit.HOURS;
        }
        if ("minutes".equals(part) || "minute".equals(part) || "min".equals(part)) {
            return DateUnit.MINUTES;
        }
        if ("seconds".equals(part) || "sec".equals(part) || "s".equals(part)) {
            return DateUnit.SECONDS;
        }
        if ("years".equals(part) || "year".equals(part)) {
            return DateUnit.YEARS;
        }
        if ("quarters".equals(part) || "quarter".equals(part) || "q".equals(part)) {
            return DateUnit.QUARTERS;
        }
        if ("months".equals(part) || "month".equals(part)) {
            return DateUnit.MONTHS;
        }
        if ("weeks".equals(part) || "week".equals(part) || "w".equals(part)) {
            return DateUnit.WEEKS;
        }
        if ("days".equals(part) || "day".equals(part) || "d".equals(part)) {
            return DateUnit.DAYS;
        }
        throw new IllegalArgumentException("Date unit '" + part + "' not recognized.");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.DateTrunc.DOCUMENTATION", "Truncates a date to a given unit. The available units are: hours, minutes, seconds, years, months, days, weeks.").withParams("date d, string unit").withReturns("date").withCategory("GREL.FUNCTIONS.CATEGORY.DATE", "Date functions").withExample(Example.with("'2020-04-03T07:47:45.245Z'", "'month'").returns("2020-04-01T00:00:00.000Z"));
    }

    public static enum DateUnit {
        HOURS,
        MINUTES,
        SECONDS,
        YEARS,
        QUARTERS,
        MONTHS,
        WEEKS,
        DAYS;

    }
}

