/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import com.dataiku.dip.input.formats.hive.serde.DSSInspectionException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.json.JSONException;
import org.json.JSONObject;

public class DSSMapObjectInspector
extends StandardMapObjectInspector
implements DSSBaseInspector {
    private DSSBaseInspector parent;

    public DSSMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector) {
        super(mapKeyObjectInspector, mapValueObjectInspector);
        if (!StringUtils.equals((String)mapKeyObjectInspector.getTypeName(), (String)"string")) {
            throw new DSSInspectionException((DSSBaseInspector)this, "Non-string map keys are not supported by the DSS SequenceFile writer");
        }
    }

    private JSONObject get(Object data) {
        if (data != null && !JSONObject.NULL.equals(data)) {
            if (data instanceof JSONObject) {
                return (JSONObject)data;
            }
            throw new DSSInspectionException((DSSBaseInspector)this, "JSONObject expected: " + String.valueOf(data));
        }
        return null;
    }

    public int getMapSize(Object data) {
        JSONObject obj = this.get(data);
        if (obj == null) {
            return -1;
        }
        return obj.length();
    }

    public Object getMapValueElement(Object data, Object key) {
        JSONObject obj = this.get(data);
        if (obj == null || key == null || !(key instanceof String)) {
            return null;
        }
        String strKey = (String)key;
        if (obj.has(strKey)) {
            try {
                Object o = obj.get((String)key);
                if (JSONObject.NULL.equals(o)) {
                    o = null;
                }
                return o;
            }
            catch (JSONException e) {
                throw new DSSInspectionException((DSSBaseInspector)this, (Throwable)e);
            }
        }
        return null;
    }

    public Map<?, ?> getMap(Object data) {
        JSONObject obj = this.get(data);
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> out = new HashMap<String, Object>();
        Iterator keys = obj.keys();
        try {
            while (keys.hasNext()) {
                Object untypedKey = keys.next();
                if (untypedKey == null) {
                    throw new DSSInspectionException((DSSBaseInspector)this, "Map key cannot be null");
                }
                if (!(untypedKey instanceof String)) {
                    throw new DSSInspectionException((DSSBaseInspector)this, "Map key should be string but is " + untypedKey.getClass().getSimpleName());
                }
                String k = (String)untypedKey;
                Object o = obj.get(k);
                if (JSONObject.NULL.equals(o)) {
                    o = null;
                }
                out.put(k, o);
            }
        }
        catch (JSONException e) {
            throw new DSSInspectionException((DSSBaseInspector)this, (Throwable)e);
        }
        return out;
    }

    public Object create() {
        throw new RuntimeException("I am not inspectable");
    }

    public Object clear(Object map) {
        throw new RuntimeException("I am not inspectable");
    }

    public Object put(Object map, Object key, Object value) {
        throw new RuntimeException("I am not inspectable");
    }

    public Object remove(Object map, Object key) {
        throw new RuntimeException("I am not inspectable");
    }

    @Override
    public DSSBaseInspector getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DSSBaseInspector parent) {
        this.parent = parent;
    }
}

