/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.dataiku.dss.shadelibtd.com.google.common.collect.Multimap;
import com.treasuredata.client.BackOffStrategy;
import com.treasuredata.client.ProxyConfig;
import com.treasuredata.client.TDClientConfig;
import com.treasuredata.client.TDClientException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;

public abstract class AbstractTDClientBuilder<ClientImpl, BuilderImpl extends AbstractTDClientBuilder<ClientImpl, BuilderImpl>> {
    protected Optional<String> endpoint = Optional.empty();
    protected Optional<Integer> port = Optional.empty();
    protected boolean useSSL = true;
    protected Optional<String> apiKey = Optional.empty();
    protected Optional<String> user = Optional.empty();
    protected Optional<String> password = Optional.empty();
    protected Optional<ProxyConfig> proxy = Optional.empty();
    protected BackOffStrategy retryStrategy = BackOffStrategy.FullJitter;
    protected int retryLimit = 7;
    protected int retryInitialIntervalMillis = 500;
    protected int retryMaxIntervalMillis = 60000;
    protected double retryMultiplier = 2.0;
    protected int connectTimeoutMillis = 15000;
    protected int readTimeoutMillis = 60000;
    protected int connectionPoolSize = 64;
    protected Map<String, Collection<String>> headers = Collections.emptyMap();

    private static Optional<String> getConfigProperty(Properties p, TDClientConfig.Type key) {
        return AbstractTDClientBuilder.getConfigProperty(p, key.key);
    }

    private static Optional<String> getConfigProperty(Properties p, String key) {
        return Optional.ofNullable(p.getProperty(key));
    }

    private static Optional<Integer> getConfigPropertyInt(Properties p, TDClientConfig.Type key) {
        return AbstractTDClientBuilder.getConfigPropertyInt(p, key.key);
    }

    private static Optional<Integer> getConfigPropertyInt(Properties p, String key) {
        String v = p.getProperty(key);
        if (v != null) {
            try {
                return Optional.of(Integer.parseInt(v));
            }
            catch (NumberFormatException e) {
                throw new TDClientException(TDClientException.ErrorType.INVALID_CONFIGURATION, String.format("[%s] cannot cast %s to integer", key, v));
            }
        }
        return Optional.empty();
    }

    private static Optional<Boolean> getConfigPropertyBoolean(Properties p, TDClientConfig.Type key) {
        return AbstractTDClientBuilder.getConfigPropertyBoolean(p, key.key);
    }

    private static Optional<Boolean> getConfigPropertyBoolean(Properties p, String key) {
        String v = p.getProperty(key);
        if (v != null) {
            try {
                return Optional.of(Boolean.parseBoolean(v));
            }
            catch (NumberFormatException e) {
                throw new TDClientException(TDClientException.ErrorType.INVALID_CONFIGURATION, String.format("[%s] cannot cast %s to boolean", key, v));
            }
        }
        return Optional.empty();
    }

    private static Optional<Double> getConfigPropertyDouble(Properties p, TDClientConfig.Type key) {
        String v = p.getProperty(key.key);
        if (v != null) {
            try {
                return Optional.of(Double.parseDouble(v));
            }
            catch (NumberFormatException e) {
                throw new TDClientException(TDClientException.ErrorType.INVALID_CONFIGURATION, String.format("[%s] cannot cast %s to double", new Object[]{key, v}));
            }
        }
        return Optional.empty();
    }

    protected AbstractTDClientBuilder(boolean loadTDConf) {
        String apiKeyEnv = System.getenv("TD_API_KEY");
        if (apiKeyEnv != null) {
            this.setApiKey(apiKeyEnv);
        }
        this.setProperties(System.getProperties());
        if (loadTDConf) {
            this.setProperties(TDClientConfig.getTDConfProperties());
        }
    }

    public BuilderImpl setProperties(Properties p) {
        ProxyConfig.ProxyConfigBuilder proxyConfig;
        this.endpoint = Stream.of(AbstractTDClientBuilder.getConfigProperty(p, TDClientConfig.Type.API_ENDPOINT), AbstractTDClientBuilder.getConfigProperty(p, "endpoint"), this.endpoint).flatMap(opt -> opt.map(Stream::of).orElseGet(Stream::empty)).findFirst();
        this.port = Stream.of(AbstractTDClientBuilder.getConfigPropertyInt(p, TDClientConfig.Type.API_PORT), AbstractTDClientBuilder.getConfigPropertyInt(p, "port"), this.port).flatMap(opt -> opt.map(Stream::of).orElseGet(Stream::empty)).findFirst();
        this.useSSL = Stream.of(AbstractTDClientBuilder.getConfigPropertyBoolean(p, TDClientConfig.Type.USESSL), AbstractTDClientBuilder.getConfigPropertyBoolean(p, "usessl")).flatMap(opt -> opt.map(Stream::of).orElseGet(Stream::empty)).findFirst().orElse(this.useSSL);
        this.apiKey = Stream.of(AbstractTDClientBuilder.getConfigProperty(p, TDClientConfig.Type.APIKEY), AbstractTDClientBuilder.getConfigProperty(p, "apikey"), this.apiKey).flatMap(opt -> opt.map(Stream::of).orElseGet(Stream::empty)).findFirst();
        this.user = Stream.of(AbstractTDClientBuilder.getConfigProperty(p, TDClientConfig.Type.USER), AbstractTDClientBuilder.getConfigProperty(p, "user"), this.user).flatMap(opt -> opt.map(Stream::of).orElseGet(Stream::empty)).findFirst();
        this.password = Stream.of(AbstractTDClientBuilder.getConfigProperty(p, TDClientConfig.Type.PASSOWRD), AbstractTDClientBuilder.getConfigProperty(p, "password"), this.password).flatMap(opt -> opt.map(Stream::of).orElseGet(Stream::empty)).findFirst();
        boolean hasProxy = false;
        if (this.proxy.isPresent()) {
            hasProxy = true;
            proxyConfig = new ProxyConfig.ProxyConfigBuilder(this.proxy.get());
        } else {
            proxyConfig = new ProxyConfig.ProxyConfigBuilder();
        }
        Optional<String> proxyHost = AbstractTDClientBuilder.getConfigProperty(p, TDClientConfig.Type.PROXY_HOST);
        Optional<Integer> proxyPort = AbstractTDClientBuilder.getConfigPropertyInt(p, TDClientConfig.Type.PROXY_PORT);
        Optional<String> proxyUseSSL = AbstractTDClientBuilder.getConfigProperty(p, TDClientConfig.Type.PROXY_USESSL);
        Optional<String> proxyUser = AbstractTDClientBuilder.getConfigProperty(p, TDClientConfig.Type.PROXY_USER);
        Optional<String> proxyPassword = AbstractTDClientBuilder.getConfigProperty(p, TDClientConfig.Type.PROXY_PASSWORD);
        if (proxyHost.isPresent()) {
            hasProxy = true;
            proxyConfig.setHost(proxyHost.get());
        }
        if (proxyPort.isPresent()) {
            hasProxy = true;
            proxyConfig.setPort(proxyPort.get());
        }
        if (proxyUseSSL.isPresent()) {
            hasProxy = true;
            proxyConfig.useSSL(Boolean.parseBoolean(proxyUseSSL.get()));
        }
        if (proxyUser.isPresent()) {
            hasProxy = true;
            proxyConfig.setUser(proxyUser.get());
        }
        if (proxyPassword.isPresent()) {
            hasProxy = true;
            proxyConfig.setPassword(proxyPassword.get());
        }
        this.proxy = Optional.ofNullable(hasProxy ? proxyConfig.createProxyConfig() : null);
        this.retryLimit = AbstractTDClientBuilder.getConfigPropertyInt(p, TDClientConfig.Type.RETRY_LIMIT).orElse(this.retryLimit);
        this.retryInitialIntervalMillis = AbstractTDClientBuilder.getConfigPropertyInt(p, TDClientConfig.Type.RETRY_INITIAL_INTERVAL_MILLIS).orElse(this.retryInitialIntervalMillis);
        this.retryMaxIntervalMillis = AbstractTDClientBuilder.getConfigPropertyInt(p, TDClientConfig.Type.RETRY_MAX_INTERVAL_MILLIS).orElse(this.retryMaxIntervalMillis);
        this.retryMultiplier = AbstractTDClientBuilder.getConfigPropertyDouble(p, TDClientConfig.Type.RETRY_MULTIPLIER).orElse(this.retryMultiplier);
        this.connectTimeoutMillis = AbstractTDClientBuilder.getConfigPropertyInt(p, TDClientConfig.Type.CONNECT_TIMEOUT_MILLIS).orElse(this.connectTimeoutMillis);
        this.readTimeoutMillis = AbstractTDClientBuilder.getConfigPropertyInt(p, TDClientConfig.Type.READ_TIMEOUT_MILLIS).orElse(this.readTimeoutMillis);
        this.connectionPoolSize = AbstractTDClientBuilder.getConfigPropertyInt(p, TDClientConfig.Type.CONNECTION_POOL_SIZE).orElse(this.connectionPoolSize);
        return this.self();
    }

    public BuilderImpl setEndpoint(String endpoint) {
        this.endpoint = Optional.of(endpoint);
        return this.self();
    }

    public BuilderImpl setPort(int port) {
        this.port = Optional.of(port);
        return this.self();
    }

    public BuilderImpl setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
        return this.self();
    }

    public BuilderImpl setApiKey(String apiKey) {
        this.apiKey = Optional.of(apiKey);
        return this.self();
    }

    public BuilderImpl setUser(String user) {
        this.user = Optional.of(user);
        return this.self();
    }

    public BuilderImpl setPassword(String password) {
        this.password = Optional.of(password);
        return this.self();
    }

    public BuilderImpl setProxy(ProxyConfig proxyConfig) {
        this.proxy = Optional.of(proxyConfig);
        return this.self();
    }

    public BuilderImpl setRetryStrategy(BackOffStrategy strategy) {
        this.retryStrategy = strategy;
        return this.self();
    }

    public BuilderImpl setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
        return this.self();
    }

    public BuilderImpl setRetryInitialIntervalMillis(int retryInitialIntervalMillis) {
        this.retryInitialIntervalMillis = retryInitialIntervalMillis;
        return this.self();
    }

    public BuilderImpl setRetryMaxIntervalMillis(int retryMaxIntervalMillis) {
        this.retryMaxIntervalMillis = retryMaxIntervalMillis;
        return this.self();
    }

    public BuilderImpl setRetryMultiplier(double retryMultiplier) {
        this.retryMultiplier = retryMultiplier;
        return this.self();
    }

    public BuilderImpl setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this.self();
    }

    public BuilderImpl setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return this.self();
    }

    public BuilderImpl setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this.self();
    }

    @Deprecated
    public BuilderImpl setHeaders(Multimap<String, String> headers) {
        return this.setHeaders(headers.asMap());
    }

    public BuilderImpl setHeaders(Map<String, ? extends Collection<String>> headers) {
        this.headers = Collections.unmodifiableMap(new HashMap<String, Collection<String>>(headers));
        return this.self();
    }

    public TDClientConfig buildConfig() {
        return new TDClientConfig(this.endpoint, this.port, this.useSSL, this.apiKey, this.user, this.password, this.proxy, this.retryStrategy, this.retryLimit, this.retryInitialIntervalMillis, this.retryMaxIntervalMillis, this.retryMultiplier, this.connectTimeoutMillis, this.readTimeoutMillis, this.connectionPoolSize, this.headers);
    }

    protected abstract BuilderImpl self();

    public abstract ClientImpl build();
}

