/*
 * Decompiled with CFR 0.152.
 */
package org.w3.xlink.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.w3.xlink.ActuateType;
import org.w3.xlink.ArcType;
import org.w3.xlink.DocumentRoot;
import org.w3.xlink.Extended;
import org.w3.xlink.LocatorType;
import org.w3.xlink.ResourceType;
import org.w3.xlink.ShowType;
import org.w3.xlink.Simple;
import org.w3.xlink.TitleEltType;
import org.w3.xlink.TypeType;
import org.w3.xlink.XlinkPackage;

public class XlinkValidator
extends EObjectValidator {
    public static final XlinkValidator INSTANCE = new XlinkValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.w3.xlink";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;

    protected EPackage getEPackage() {
        return XlinkPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map context) {
        switch (classifierID) {
            case 0: {
                return this.validateArcType((ArcType)value, diagnostics, context);
            }
            case 1: {
                return this.validateDocumentRoot((DocumentRoot)value, diagnostics, context);
            }
            case 2: {
                return this.validateExtended((Extended)value, diagnostics, context);
            }
            case 3: {
                return this.validateLocatorType((LocatorType)value, diagnostics, context);
            }
            case 4: {
                return this.validateResourceType((ResourceType)value, diagnostics, context);
            }
            case 5: {
                return this.validateSimple((Simple)value, diagnostics, context);
            }
            case 6: {
                return this.validateTitleEltType((TitleEltType)value, diagnostics, context);
            }
            case 7: {
                return this.validateObject(value, diagnostics, context);
            }
            case 8: {
                return this.validateActuateType((ActuateType)value, diagnostics, context);
            }
            case 9: {
                return this.validateShowType((ShowType)value, diagnostics, context);
            }
            case 10: {
                return this.validateTypeType((TypeType)value, diagnostics, context);
            }
            case 11: {
                return this.validateActuateTypeObject((ActuateType)value, diagnostics, context);
            }
            case 12: {
                return this.validateArcroleType((String)value, diagnostics, context);
            }
            case 13: {
                return this.validateFromType((String)value, diagnostics, context);
            }
            case 14: {
                return this.validateHrefType((String)value, diagnostics, context);
            }
            case 15: {
                return this.validateLabelType((String)value, diagnostics, context);
            }
            case 16: {
                return this.validateRoleType((String)value, diagnostics, context);
            }
            case 17: {
                return this.validateShowTypeObject((ShowType)value, diagnostics, context);
            }
            case 18: {
                return this.validateTitleAttrType((String)value, diagnostics, context);
            }
            case 19: {
                return this.validateToType((String)value, diagnostics, context);
            }
            case 20: {
                return this.validateTypeTypeObject((TypeType)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateArcType(ArcType arcType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(arcType, diagnostics, context);
    }

    public boolean validateDocumentRoot(DocumentRoot documentRoot, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(documentRoot, diagnostics, context);
    }

    public boolean validateExtended(Extended extended, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(extended, diagnostics, context);
    }

    public boolean validateLocatorType(LocatorType locatorType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(locatorType, diagnostics, context);
    }

    public boolean validateResourceType(ResourceType resourceType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(resourceType, diagnostics, context);
    }

    public boolean validateSimple(Simple simple, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(simple, diagnostics, context);
    }

    public boolean validateTitleEltType(TitleEltType titleEltType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(titleEltType, diagnostics, context);
    }

    public boolean validateObject(Object object, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint((EObject)object, diagnostics, context);
    }

    public boolean validateActuateType(ActuateType actuateType, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateShowType(ShowType showType, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateTypeType(TypeType typeType, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateActuateTypeObject(ActuateType actuateTypeObject, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateArcroleType(String arcroleType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateArcroleType_MinLength(arcroleType, diagnostics, context);
        return result;
    }

    public boolean validateArcroleType_MinLength(String arcroleType, DiagnosticChain diagnostics, Map context) {
        boolean result;
        int length = arcroleType.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(XlinkPackage.Literals.ARCROLE_TYPE, arcroleType, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateFromType(String fromType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.xmlTypeValidator.validateNCName_Pattern(fromType, diagnostics, context);
        return result;
    }

    public boolean validateHrefType(String hrefType, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateLabelType(String labelType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.xmlTypeValidator.validateNCName_Pattern(labelType, diagnostics, context);
        return result;
    }

    public boolean validateRoleType(String roleType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateRoleType_MinLength(roleType, diagnostics, context);
        return result;
    }

    public boolean validateRoleType_MinLength(String roleType, DiagnosticChain diagnostics, Map context) {
        boolean result;
        int length = roleType.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(XlinkPackage.Literals.ROLE_TYPE, roleType, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateShowTypeObject(ShowType showTypeObject, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateTitleAttrType(String titleAttrType, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateToType(String toType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.xmlTypeValidator.validateNCName_Pattern(toType, diagnostics, context);
        return result;
    }

    public boolean validateTypeTypeObject(TypeType typeTypeObject, DiagnosticChain diagnostics, Map context) {
        return true;
    }
}

