/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.expr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;

public class ExtractNumbersAlgorithm {
    private final Parameter param;

    public ExtractNumbersAlgorithm(Parameter param) {
        this.param = param;
    }

    public Double processForSingleValue(String inV) {
        List<Double> l = this.extractNumbers(inV, true);
        if (l.isEmpty()) {
            return null;
        }
        return l.get(0);
    }

    public List<Double> processForMultipleValues(String inV) {
        return this.extractNumbers(inV, false);
    }

    public String processForJSONArray(String inV) {
        List<Double> l = this.processForMultipleValues(inV);
        if (l.isEmpty()) {
            return null;
        }
        return new JSONArray(l).toString();
    }

    private List<Double> extractNumbers(String s, boolean singleValue) {
        if (s == null || s.length() == 0) {
            return new ArrayList<Double>();
        }
        Pattern replaceCommas = Pattern.compile("(\\d),(\\d+)");
        Pattern replaceDots = Pattern.compile("(\\d)\\.(\\d+)");
        Pattern replaceThousands = Pattern.compile("(\\d{1,3})[ ,.](\\d{3})(?!\\d)");
        Pattern replaceMillions = Pattern.compile("(\\d{1,3})[ ,.](\\d{3})[ ,.](\\d{3})(?!\\d)");
        if (this.param.delimiter == DecimalDelimiter.COMMA) {
            s = replaceDots.matcher(s).replaceAll("$1a$2");
            s = replaceCommas.matcher(s).replaceAll("$1.$2");
        } else if (this.param.delimiter == DecimalDelimiter.BEST_GUESS) {
            s = replaceCommas.matcher(s).replaceAll("$1.$2");
            s = replaceMillions.matcher(s).replaceAll("$1$2$3");
            s = replaceThousands.matcher(s).replaceAll("$1$2");
        }
        Pattern numbersPattern = this.param.delimiter == DecimalDelimiter.BEST_GUESS ? Pattern.compile("(\\d+\\.)?(\\d+)\\s?([KkmM]?)") : Pattern.compile("(\\d+\\.)?(\\d+)([KkmM]?)");
        Matcher numbersMatcher = numbersPattern.matcher(s);
        ArrayList<Double> res = new ArrayList<Double>();
        while (numbersMatcher.find()) {
            Object m = numbersMatcher.group(1) != null ? numbersMatcher.group(1) + numbersMatcher.group(2) : numbersMatcher.group(2);
            double found = Double.parseDouble((String)m);
            if (!numbersMatcher.group(3).equals("") && this.param.replaceMultipliers) {
                char last = numbersMatcher.group(3).charAt(0);
                if (last == 'k' || last == 'K') {
                    res.add(found * 1000.0);
                } else if (last == 'm' || last == 'M') {
                    res.add(found * 1000000.0);
                }
            } else {
                res.add(found);
            }
            if (res.isEmpty() || !singleValue) continue;
            return res;
        }
        return res;
    }

    public static class Parameter
    implements Serializable {
        private static final long serialVersionUID = -1L;
        boolean replaceMultipliers = false;
        DecimalDelimiter delimiter = DecimalDelimiter.BEST_GUESS;
    }

    public static enum DecimalDelimiter {
        BEST_GUESS,
        COMMA,
        DOT;

    }
}

