/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.geoip.fastgeo;

import com.dataiku.geoip.fastgeo.RangeTable;
import com.dataiku.geoip.uniquedb.InvalidDatabaseException;
import com.dataiku.geoip.uniquedb.Node;
import com.dataiku.geoip.uniquedb.UniqueDB;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FastGeoIP2 {
    private RangeTable ipv6Table;
    private RangeTable ipv4Table;
    private UniqueDB database;
    public static final int VERSION_ID = 2;
    public static final int FGDB_MARKER = 1181889348;

    public FastGeoIP2(File file) throws InvalidDatabaseException {
        try (FileInputStream fis = new FileInputStream(file);
             DataInputStream dis = FastGeoIP2.createDataInputStream(file, fis);){
            this.initialize(UniqueDB.loadFromStream(dis));
        }
        catch (IOException e) {
            throw new InvalidDatabaseException("Unable to open FastGeoIP2 database (I/O error): " + e.getMessage(), e);
        }
        catch (InvalidDatabaseException e) {
            throw new InvalidDatabaseException("Invalid FastGeoIP2 database (corrupted UniqueDB): " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try (DataOutputStream dos = file.getName().endsWith(".gz") ? new DataOutputStream(new GZIPOutputStream(bos)) : new DataOutputStream(bos);){
            this.database.writeToStream(dos);
        }
    }

    public FastGeoIP2(UniqueDB db) throws InvalidDatabaseException {
        this.initialize(db);
    }

    public Result find(InetAddress addr) {
        int[] ip = FastGeoIP2.inetToInteger(addr);
        Node node = null;
        node = ip[0] == Integer.MIN_VALUE && ip[1] == Integer.MIN_VALUE && (ip[2] == Integer.MIN_VALUE || ip[2] == -2147418113) ? this.ipv4Table.lookup(new int[]{ip[3]}) : this.ipv6Table.lookup(new int[]{ip[0], ip[1]});
        if (node != null) {
            return new Result(node);
        }
        return null;
    }

    public static int[] inetToInteger(InetAddress addr) {
        byte[] bytes = addr.getAddress();
        int[] out = new int[4];
        if (bytes.length == 16) {
            for (int i = 0; i < 4; ++i) {
                out[i] = (int)((((long)bytes[4 * i] & 0xFFL) << 24 | ((long)bytes[4 * i + 1] & 0xFFL) << 16 | ((long)bytes[4 * i + 2] & 0xFFL) << 8 | (long)bytes[4 * i + 3] & 0xFFL) + Integer.MIN_VALUE);
            }
        } else if (bytes.length == 4) {
            out[0] = Integer.MIN_VALUE;
            out[1] = Integer.MIN_VALUE;
            out[2] = -2147418113;
            out[3] = (int)((((long)bytes[0] & 0xFFL) << 24 | ((long)bytes[1] & 0xFFL) << 16 | ((long)bytes[2] & 0xFFL) << 8 | (long)bytes[3] & 0xFFL) + Integer.MIN_VALUE);
        } else {
            throw new RuntimeException("Unreachable");
        }
        return out;
    }

    private void initialize(UniqueDB db) throws InvalidDatabaseException {
        this.database = db;
        if (db.root().size() != 4 || db.root().getInteger(0) != 1181889348 || db.root().getInteger(1) != 2) {
            throw new InvalidDatabaseException("Cannot load FastGeoIP2 database (invalid database or incompatible version)");
        }
        this.ipv4Table = new RangeTable(db.root().getNode(2));
        this.ipv6Table = new RangeTable(db.root().getNode(3));
    }

    private static DataInputStream createDataInputStream(File file, FileInputStream fis) throws IOException {
        if (file.getName().endsWith(".gz")) {
            return new DataInputStream(new BufferedInputStream(new GZIPInputStream(fis)));
        }
        return new DataInputStream(new BufferedInputStream(fis));
    }

    public static final class Result {
        private Node root;

        Result(Node root) {
            this.root = root;
        }

        public String getCity() {
            return this.root.getString(3);
        }

        public String getPostalCode() {
            return this.root.getString(2);
        }

        public String getCountryCode() {
            return this.root.getNode(4).getString(2);
        }

        public String getTimezone() {
            return this.root.getNode(4).getString(3);
        }

        public String getCountry() {
            return this.root.getNode(4).getString(1);
        }

        public String getContinent() {
            return this.root.getNode(4).getNode(4).getString(0);
        }

        public String getContinentCode() {
            return this.root.getNode(4).getNode(4).getString(1);
        }

        public String getLatitude() {
            return this.root.getString(0);
        }

        public String getLongitude() {
            return this.root.getString(1);
        }

        public List<Subdivision> getSubdivisions() {
            Node arr = this.root.getNode(4).getNode(0);
            ArrayList<Subdivision> list = new ArrayList<Subdivision>();
            for (int i = 0; i < arr.size(); ++i) {
                Subdivision sub = new Subdivision();
                sub.name = arr.getNode(i).getString(0);
                sub.code = arr.getNode(i).getString(1);
                list.add(sub);
            }
            return list;
        }

        public static class Subdivision {
            public String name;
            public String code;
        }
    }
}

