/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.styling.visitor.Measure;
import org.geotools.styling.visitor.RescalingMode;
import org.opengis.filter.capability.FunctionName;

public class RescaleToPixelsFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("rescaleToPixels", String.class, FunctionNameImpl.parameter("value", String.class), FunctionNameImpl.parameter("defaultUnit", Unit.class), FunctionNameImpl.parameter("scaleFactor", Double.class), FunctionNameImpl.parameter("rescalingMode", RescalingMode.class, 0, 1));

    public RescaleToPixelsFunction() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        RescalingMode theMode;
        String value = (String)this.getExpression(0).evaluate(feature, String.class);
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        Unit defaultUnit = (Unit)this.getExpression(1).evaluate(feature, Unit.class);
        Double scaleFactor = (Double)this.getExpression(2).evaluate(feature, Double.class);
        if (scaleFactor == null) {
            throw new IllegalArgumentException("Invalid scale factor, it should be non null");
        }
        RescalingMode mode = RescalingMode.KeepUnits;
        if (this.getParameters().size() >= 3 && (theMode = (RescalingMode)((Object)this.getExpression(3).evaluate(feature, RescalingMode.class))) != null) {
            mode = theMode;
        }
        Measure measure = new Measure(value, (Unit<Length>)defaultUnit);
        String result = mode.rescaleToString(scaleFactor, measure);
        return result;
    }
}

