/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyHostsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ModifyHostsRequestMarshaller
implements Marshaller<Request<ModifyHostsRequest>, ModifyHostsRequest> {
    @Override
    public Request<ModifyHostsRequest> marshall(ModifyHostsRequest modifyHostsRequest) {
        SdkInternalList modifyHostsRequestHostIdsList;
        if (modifyHostsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyHostsRequest> request = new DefaultRequest<ModifyHostsRequest>(modifyHostsRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyHostsRequest.getAutoPlacement() != null) {
            request.addParameter("AutoPlacement", StringUtils.fromString(modifyHostsRequest.getAutoPlacement()));
        }
        if (!(modifyHostsRequestHostIdsList = (SdkInternalList)modifyHostsRequest.getHostIds()).isEmpty() || !modifyHostsRequestHostIdsList.isAutoConstruct()) {
            int hostIdsListIndex = 1;
            for (String modifyHostsRequestHostIdsListValue : modifyHostsRequestHostIdsList) {
                if (modifyHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString(modifyHostsRequestHostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        if (modifyHostsRequest.getHostRecovery() != null) {
            request.addParameter("HostRecovery", StringUtils.fromString(modifyHostsRequest.getHostRecovery()));
        }
        if (modifyHostsRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString(modifyHostsRequest.getInstanceType()));
        }
        if (modifyHostsRequest.getInstanceFamily() != null) {
            request.addParameter("InstanceFamily", StringUtils.fromString(modifyHostsRequest.getInstanceFamily()));
        }
        if (modifyHostsRequest.getHostMaintenance() != null) {
            request.addParameter("HostMaintenance", StringUtils.fromString(modifyHostsRequest.getHostMaintenance()));
        }
        return request;
    }
}

