/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.directory;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.security.PasswordEncryptionService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class NodesDirectory {
    public boolean enabled;
    public List<NodeRef> nodes = new ArrayList<NodeRef>();
    public List<LoadBalancerRef> loadBalancers = new ArrayList<LoadBalancerRef>();
    public String remoteDeployerNodeId;
    public String eventServerNodeId;
    public String governNodeId;

    public NodeRef getCurrentNode() {
        String nodeId = DKUApp.getNodeId();
        if (StringUtils.isBlank((String)nodeId)) {
            throw new IllegalArgumentException("Current node does not have a nodeid, can't look it up in the nodes directory");
        }
        return this.getById(nodeId).orElseThrow(() -> new IllegalArgumentException("Current node id not found in directory"));
    }

    public Optional<NodeRef> getById(String nodeId) {
        if (nodeId == null) {
            return Optional.empty();
        }
        return this.nodes.stream().filter(nr -> nodeId.equals(nr.nodeId)).findFirst();
    }

    private boolean isInstanceUp(String nodeId) {
        Optional<NodeRef> ref = this.getById(nodeId);
        if (ref.isPresent()) {
            return ref.get().url != null;
        }
        return false;
    }

    public boolean hasRemoteDeployerNode() {
        return this.getById(this.remoteDeployerNodeId).isPresent();
    }

    public boolean isRemoteDeployerInstanceUp() {
        return this.isInstanceUp(this.remoteDeployerNodeId);
    }

    public boolean hasEventServerNode() {
        return this.getById(this.eventServerNodeId).isPresent();
    }

    public boolean isEventServerInstanceUp() {
        return this.isInstanceUp(this.eventServerNodeId);
    }

    public boolean hasGovernNode() {
        return this.getById(this.governNodeId).isPresent();
    }

    public boolean isGovernInstanceUp() {
        return this.isInstanceUp(this.governNodeId);
    }

    public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
        this.nodes.forEach(node -> node.encryptFields(passwordEncryptionService));
    }

    public static class NodeRef {
        public String nodeId;
        public NodeType nodeType;
        public String url;
        public String externalUrl;
        public String adminAPIKey;
        public String eventServerAuthKey;
        public boolean configureDeployerServer;
        public boolean configureEventServer;
        public Boolean singleNodeAsInfrastructure;
        public NodeStatus status;

        public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
            this.adminAPIKey = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(this.adminAPIKey);
        }
    }

    public static class LoadBalancerRef {
        public String id;
        public Map<String, Set<String>> targets = new HashMap<String, Set<String>>();
        public String link;
    }

    public static enum NodeStatus {
        NOT_PROVISIONED,
        STARTING,
        RUNNING,
        IN_ERROR,
        NOT_RESPONDING;

    }

    public static enum NodeType {
        DSS_DESIGN,
        DSS_EXECUTION,
        DSS_DEPLOYER,
        GOVERN;

    }
}

