/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.exceptions.StackTraceElt;
import com.dataiku.dip.io.JavaBlockLink;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.io.SocketBlockLink;
import com.dataiku.dip.io.SocketBlockLinkEarlyStopException;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.io.SocketBlockLinkIOException;
import com.dataiku.dip.io.SocketBlockLinkKernelException;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SocketBlockLinkInteraction<T> {
    private final JavaBlockLink link;
    private Object req;
    private InputStream is;
    private OutputStream os;
    private Class<? extends T> respClazz;
    private TypeToken<? extends T> respTypeToken;
    private boolean respIsString;
    private String exceptionIfNullMessage;
    private boolean asyncInputStream;
    private static Logger logger = Logger.getLogger((String)"dku.block.link.interaction");

    public SocketBlockLinkInteraction(JavaBlockLink link) {
        this.link = link;
    }

    public SocketBlockLinkInteraction<T> withRequest(Object req) {
        this.req = req;
        return this;
    }

    public SocketBlockLinkInteraction<T> withStream(InputStream is) {
        this.is = is;
        return this;
    }

    public SocketBlockLinkInteraction<T> withAsyncStream() {
        this.asyncInputStream = true;
        return this;
    }

    public SocketBlockLinkInteraction<T> expectsStream(OutputStream os) {
        this.os = os;
        return this;
    }

    public SocketBlockLinkInteraction<T> expectsObject(Class<? extends T> respClazz) {
        this.respClazz = respClazz;
        return this;
    }

    public SocketBlockLinkInteraction<T> expectsObject(TypeToken<? extends T> respTypeToken) {
        this.respTypeToken = respTypeToken;
        return this;
    }

    public SocketBlockLinkInteraction<T> expectsString() {
        this.respIsString = true;
        return this;
    }

    public SocketBlockLinkInteraction<T> withExceptionIfNullMessage(String exceptionIfNullMessage) {
        this.exceptionIfNullMessage = exceptionIfNullMessage;
        return this;
    }

    public T execute() throws IOException {
        return this.executeAsync().get();
    }

    public AsyncResult<T> executeAsync() throws IOException {
        logger.info((Object)("Execute link command respClazz=" + (this.respClazz != null) + " respTypeToken=" + (this.respTypeToken != null) + " respIsString=" + this.respIsString + " is=" + (this.is != null) + " asyncInputStream=" + this.asyncInputStream + " os=" + (this.os != null)));
        if (this.exceptionIfNullMessage != null) {
            if (this.os != null) {
                throw new IllegalArgumentException("Cannot use empty block as marker for exception when using stream output");
            }
            if (this.respClazz == null && this.respTypeToken == null && !this.respIsString) {
                throw new IllegalArgumentException("Cannot use empty block as marker for exception when no output is expected");
            }
        }
        if (this.is != null && this.asyncInputStream) {
            throw new IllegalArgumentException("Cannot use both input stream and async input stream");
        }
        if (this.req != null) {
            try {
                this.link.sendRequest(this.req);
            }
            catch (IOException e) {
                throw new IOException("Failed to send command to kernel", e);
            }
        }
        if (this.asyncInputStream && this.respClazz == null) {
            throw new IllegalArgumentException("Async input stream requires a response type extending OutputStream");
        }
        StreamConsumer output = null;
        if (this.os != null) {
            output = new StreamConsumer(this.link, this.os);
            output.start();
        }
        StreamSupplier input = null;
        JavaBlockLink.WrappedSocketBlockLinkOutputStream inputAsync = null;
        if (this.is != null) {
            input = new StreamSupplier(this.link, this.is);
            input.start();
        } else if (this.asyncInputStream) {
            inputAsync = this.link.sendStreamAsync(0x100000);
        }
        return new AsyncResult<T>(this.link, this.exceptionIfNullMessage, output, input, inputAsync, this.respClazz, this.respTypeToken, this.respIsString);
    }

    public static IOException throwExceptionFromPython(SocketBlockLink link, String exceptionIfNullMessage) {
        return SocketBlockLinkInteraction.throwExceptionFromPython(link.getBlockLink(), exceptionIfNullMessage);
    }

    public static IOException throwExceptionFromPython(JavaBlockLink link, String exceptionIfNullMessage) {
        try {
            SocketBlockLinkKernelError error = link.receiveJsonResponse(SocketBlockLinkKernelError.class);
            return new SocketBlockLinkKernelException(StringUtils.defaultIfEmpty((String)exceptionIfNullMessage, (String)"Failure in kernel"), error);
        }
        catch (SocketBlockLinkKernelException e) {
            return e;
        }
        catch (IOException e) {
            return new IOException("Failed to retrieve expected kernel exception", e);
        }
    }

    public static class AsyncResult<T> {
        private final JavaBlockLink link;
        private final StreamConsumer output;
        private final StreamSupplier input;
        private final OutputStream inputAsync;
        private final boolean expectsString;
        private final Class<? extends T> clazz;
        private final TypeToken<? extends T> typeToken;
        private final String exceptionIfNullMessage;

        private AsyncResult(JavaBlockLink link, String exceptionIfNullMessage, StreamConsumer output, StreamSupplier input, OutputStream inputAsync, Class<? extends T> clazz, TypeToken<? extends T> typeToken, boolean expectsString) {
            this.link = link;
            this.exceptionIfNullMessage = exceptionIfNullMessage;
            this.output = output;
            this.input = input;
            this.inputAsync = inputAsync;
            this.clazz = clazz;
            this.typeToken = typeToken;
            this.expectsString = expectsString;
        }

        public T get() throws IOException {
            String result = null;
            ArrayList exceptions = Lists.newArrayList();
            if (this.input != null) {
                try {
                    this.input.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    exceptions.add(e);
                }
                if (this.input.getCaught() != null) {
                    exceptions.add(this.input.getCaught());
                }
            } else if (this.inputAsync != null) {
                return (T)new SocketBlockLinkCheckingOutputStream(this.inputAsync, this.link);
            }
            if (this.output != null) {
                try {
                    this.output.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    exceptions.add(e);
                }
                if (this.output.getCaughtFromCallee() != null) {
                    exceptions.add(this.output.getCaughtFromCallee());
                }
                if (this.output.getCaughtFromCaller() != null) {
                    exceptions.add(new SocketBlockLinkEarlyStopException("Stopped reading from socket early", this.output.getCaughtFromCaller()));
                }
            } else {
                try {
                    if (this.expectsString) {
                        result = this.link.receiveStringResponse();
                        this.checkException(result);
                    } else if (this.clazz != null) {
                        result = this.link.receiveJsonResponse(this.clazz);
                        this.checkException(result);
                    } else if (this.typeToken != null) {
                        result = this.link.receiveJsonResponse(this.typeToken);
                        this.checkException(result);
                    } else {
                        this.link.receiveNullCommand();
                    }
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
            }
            if (!exceptions.isEmpty()) {
                Exception last = (Exception)exceptions.get(exceptions.size() - 1);
                SocketBlockLinkException e = last instanceof SocketBlockLinkKernelException ? (SocketBlockLinkKernelException)last : new SocketBlockLinkIOException("Failed to get result from kernel", last);
                for (int i = 0; i < exceptions.size() - 1; ++i) {
                    e.addSuppressed((Throwable)exceptions.get(i));
                }
                throw e;
            }
            return (T)result;
        }

        private void checkException(Object result) throws IOException {
            logger.info((Object)("Check result for nullity exceptionIfNull=" + (this.exceptionIfNullMessage != null) + " result=" + (result == null ? "null" : "not null")));
            if (result == null && this.exceptionIfNullMessage != null) {
                throw SocketBlockLinkInteraction.throwExceptionFromPython(this.link, this.exceptionIfNullMessage);
            }
        }
    }

    protected static class StreamConsumer
    extends Thread {
        private final JavaBlockLink link;
        private final OutputStream outputStream;
        private Exception caughtFromCallee;
        private Exception caughtFromCaller;

        StreamConsumer(JavaBlockLink link, OutputStream outputStream) {
            this.link = link;
            this.outputStream = outputStream;
        }

        public Exception getCaughtFromCallee() {
            return this.caughtFromCallee;
        }

        public Exception getCaughtFromCaller() {
            return this.caughtFromCaller;
        }

        @Override
        public void run() {
            try {
                this.link.receiveStream(this.outputStream, 0x100000);
            }
            catch (JavaBlockLink.ReceiveFromSocketIOException e) {
                this.caughtFromCallee = (IOException)e.getCause();
            }
            catch (JavaBlockLink.ReceiveToStreamIOException e) {
                this.caughtFromCaller = (IOException)e.getCause();
            }
            catch (IOException e) {
                logger.error((Object)"Failed to close output of python command", (Throwable)e);
            }
            finally {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    if (this.caughtFromCaller == null) {
                        this.caughtFromCaller = e;
                    }
                    logger.error((Object)"Failed to close output of python command", (Throwable)e);
                }
            }
        }
    }

    protected static class StreamSupplier
    extends Thread {
        private final JavaBlockLink link;
        private final InputStream inputStream;
        private Exception caught;

        StreamSupplier(JavaBlockLink link, InputStream inputStream) {
            this.link = link;
            this.inputStream = inputStream;
        }

        public Exception getCaught() {
            return this.caught;
        }

        @Override
        public void run() {
            try {
                this.link.sendStream(this.inputStream, 0x100000);
            }
            catch (Exception e) {
                this.caught = e;
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    if (this.caught == null) {
                        this.caught = e;
                    }
                    logger.error((Object)"Failed to close input of python command", (Throwable)e);
                }
            }
        }
    }

    public static class SocketBlockLinkKernelError {
        public String errorType;
        public String message;
        public JsonArray traceback;
        @Nullable
        public Integer customHttpStatusCode;

        public WarningsContext.SerializedThrowable getSerializedThrowable() {
            if (StringUtils.isNotBlank((String)this.errorType)) {
                WarningsContext.SerializedThrowable error = new WarningsContext.SerializedThrowable(this.errorType + " : " + this.message);
                error.clazz = "PackagedPythonException";
                if (this.traceback != null) {
                    StringBuilder sb = new StringBuilder();
                    for (StackTraceElt elt : this.getStackTraceElts()) {
                        if (elt.file != null) {
                            sb.append(elt.file + " : " + elt.function + " (" + elt.line + ")\n");
                            continue;
                        }
                        sb.append(elt.function + "\n");
                    }
                    error.stack = sb.toString();
                }
                return error;
            }
            return null;
        }

        public List<StackTraceElt> getStackTraceElts() {
            ArrayList elts = Lists.newArrayList();
            if (this.traceback != null) {
                for (JsonElement traceElement : this.traceback) {
                    StackTraceElt funcElt = new StackTraceElt();
                    StackTraceElt lineElt = new StackTraceElt();
                    JsonArray traceElementArray = traceElement.getAsJsonArray();
                    funcElt.file = traceElementArray.size() >= 1 && !traceElementArray.get(0).isJsonNull() ? traceElementArray.get(0).getAsString() : null;
                    funcElt.line = traceElementArray.size() >= 2 && !traceElementArray.get(1).isJsonNull() ? traceElementArray.get(1).getAsInt() : 0;
                    funcElt.function = traceElementArray.size() >= 3 && !traceElementArray.get(2).isJsonNull() ? traceElementArray.get(2).getAsString() : "";
                    lineElt.function = "\t" + (traceElementArray.size() >= 4 && !traceElementArray.get(3).isJsonNull() ? traceElementArray.get(3).getAsString() : "");
                    elts.add(funcElt);
                    elts.add(lineElt);
                }
            }
            return elts;
        }

        @Nullable
        public String getPythonExceptionClassName() {
            Pattern pattern = Pattern.compile("<class '(.*\\.)?(\\w+)'>");
            Matcher matcher = pattern.matcher(this.errorType);
            return matcher.find() ? matcher.group(2) : null;
        }
    }

    public static class SocketBlockLinkCheckingOutputStream
    extends OutputStream {
        private final OutputStream os;
        private final JavaBlockLink link;
        private SecretProtectedKernelLink.AcknowledgeResponse ack;

        SocketBlockLinkCheckingOutputStream(OutputStream os, JavaBlockLink link) {
            this.os = os;
            this.link = link;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)(b & 0xFF)}, 0, 1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.os.write(b, off, len);
            }
            catch (SocketException e) {
                logger.warn((Object)"write", (Throwable)e);
                throw this.checkSocketException(e);
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                this.os.flush();
            }
            catch (SocketException e) {
                logger.warn((Object)"flush", (Throwable)e);
                throw this.checkSocketException(e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.os.close();
            }
            catch (SocketException e) {
                logger.warn((Object)"close", (Throwable)e);
                throw this.checkSocketException(e);
            }
            IOException kernelException = this.checkAcknowledge();
            if (kernelException != null) {
                throw kernelException;
            }
        }

        private SecretProtectedKernelLink.AcknowledgeResponse getAck() throws IOException {
            if (this.ack == null) {
                this.ack = this.link.receiveJsonResponse(SecretProtectedKernelLink.AcknowledgeResponse.class);
            }
            return this.ack;
        }

        private IOException checkAcknowledge() throws IOException {
            SecretProtectedKernelLink.AcknowledgeResponse resp = this.getAck();
            if (resp != null && !resp.ok) {
                return new SocketBlockLinkKernelException("Failed to write data", resp.error);
            }
            return null;
        }

        private IOException checkSocketException(IOException e) throws IOException {
            IOException kernelException = this.checkAcknowledge();
            return kernelException != null ? kernelException : e;
        }
    }
}

