/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.transactions.fs.RelFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ProtectedFiles {
    public static final String GITINFO_FILENAME = "git-info.json";
    public static final String DKU_PROJECTS_GIT_IGNORE = ".dku-projects-gitignore";
    public static final String DSS_META_DIRNAME = ".dss-meta";
    public static ProtectedFiles TRANSACTION_PROTECTED_FILES = new ProtectedFiles(".journal", ".mainlock", ".wlock", ".ts", ".dss-meta", ".git", ".gitignore", "merge-requests.json", "version-tags.json");
    public static ProtectedFiles GIT_PROTECTED_FILES = new ProtectedFiles(".journal", ".mainlock", ".wlock", ".ts", ".dss-meta", ".git");
    private final List<RelFile> protectedFiles = new ArrayList<RelFile>();

    private ProtectedFiles(String ... args) {
        for (String s : args) {
            this.add(RelFile.fromPath(s));
        }
    }

    public void add(RelFile rf) {
        this.protectedFiles.add(rf);
    }

    public boolean isProtected(RelFile rf) {
        for (RelFile pf : this.protectedFiles) {
            if (!pf.isAncestorOf(rf)) continue;
            return true;
        }
        return false;
    }

    public void assertNotProtected(RelFile rf) throws IOException {
        if (this.isProtected(rf)) {
            throw new IOException(String.valueOf(rf) + " is protected");
        }
    }

    public List<RelFile> list() {
        return this.protectedFiles;
    }
}

