/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs.utils.copy;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.fs.utils.copy.CopyMethod;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;

public class SkipUnlessHashChangedCopyMethod
implements CopyMethod {
    private final FSUtils.CopyStats stats = new FSUtils.CopyStats();
    private final CopyMethod copyMethod;

    public SkipUnlessHashChangedCopyMethod(CopyMethod copyMethod) {
        this.copyMethod = copyMethod;
    }

    @Override
    public void copyFile(ReadOnlyFS srcFS, RelFile srcFile, @Nullable RelFileAttribute srcAttr, ReadWriteFS dstFS, RelFile dstFile, @Nullable RelFileAttribute dstAttr) throws IOException {
        byte[] dstHash;
        byte[] srcHash;
        if (srcAttr != null && dstAttr != null && srcAttr.getLength() == dstAttr.getLength() && Arrays.equals(srcHash = srcFS.getHash(srcFile), dstHash = dstFS.getHash(dstFile))) {
            ++this.stats.nbFilesSkipped;
            return;
        }
        this.copyMethod.copyFile(srcFS, srcFile, srcAttr, dstFS, dstFile, dstAttr);
    }

    @Override
    public FSUtils.CopyStats getStats() {
        return this.stats.aggregate(this.copyMethod.getStats());
    }

    @Override
    public void close() throws IOException {
        this.copyMethod.close();
    }
}

