/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git;

import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.CommitQueue;
import com.dataiku.dip.transactions.git.IGitManager;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class CommitQueuesManager
implements AutoCloseable {
    private ICommitQueuesBehavior commitQueuesBehavior;
    private static final Logger logger = Logger.getLogger(CommitQueuesManager.class);

    public CommitQueuesManager(ICommitQueuesBehavior commitQueuesBehavior) {
        this.commitQueuesBehavior = commitQueuesBehavior;
    }

    public ICommitQueuesBehavior getCommitQueuesBehavior() {
        return this.commitQueuesBehavior;
    }

    public synchronized void flushPreviousCommits(List<? extends CommitDef> defs) throws IOException {
        for (CommitDef commitDef : defs) {
            this.commitQueuesBehavior.getQueue(commitDef).commitIfAliasedButNotEquals(commitDef);
        }
    }

    public synchronized void scheduleOrExecCommit(List<? extends CommitDef> defs, long delayMillis) throws IOException {
        for (CommitDef commitDef : defs) {
            this.commitQueuesBehavior.getQueue(commitDef).scheduleOrExecCommit(commitDef, delayMillis);
        }
    }

    public synchronized boolean hasExpired() {
        return this.commitQueuesBehavior.hasExpired();
    }

    public synchronized void commitExpired() throws IOException {
        this.commitQueuesBehavior.commitExpired();
    }

    @Override
    public void close() throws IOException {
        if (this.commitQueuesBehavior != null) {
            this.commitQueuesBehavior.close();
            this.commitQueuesBehavior = null;
        }
    }

    public static interface ICommitQueuesBehavior
    extends AutoCloseable {
        public IGitManager getGitManager();

        public CommitQueue getQueue(CommitDef var1);

        public boolean hasExpired();

        public void commitExpired() throws IOException;

        public void flushPendingCommits(String var1) throws IOException;

        @Override
        public void close() throws IOException;
    }

    public static class GlobalCommitQueuesBehavior
    implements ICommitQueuesBehavior {
        private IGitManager manager;
        private CommitQueue queue;

        public GlobalCommitQueuesBehavior(IGitManager manager) {
            this.manager = manager;
            this.queue = new CommitQueue(manager);
        }

        @Override
        public IGitManager getGitManager() {
            return this.manager;
        }

        @Override
        public CommitQueue getQueue(CommitDef def) {
            return this.queue;
        }

        @Override
        public boolean hasExpired() {
            return this.queue.hasExpired();
        }

        @Override
        public void commitExpired() throws IOException {
            this.queue.commitExpired();
        }

        @Override
        public void flushPendingCommits(String projectKey) {
        }

        @Override
        public void close() throws IOException {
            if (this.manager != null) {
                this.manager.close();
                this.manager = null;
            }
        }
    }
}

