/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.j3ts;

import com.dataiku.dip.transactions.fs.InMemoryFS;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.j3ts.ClassScanner;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class Translator {
    protected final List<ClassScanner.RootMapping> rootMappings = new ArrayList<ClassScanner.RootMapping>();
    final File inputDirectory;
    final File outputDirectory;
    final boolean shouldGenerateMetadata;

    public Translator(File inputDirectory, File outputDirectory, boolean shouldGenerateMetadata) {
        this.inputDirectory = inputDirectory;
        this.outputDirectory = outputDirectory;
        this.shouldGenerateMetadata = shouldGenerateMetadata;
    }

    protected static void syncChangesToDisk(InMemoryFS files, File outDir) throws IOException {
        Stopwatch sw = Stopwatch.createStarted();
        if (!outDir.mkdirs() && !outDir.isDirectory()) {
            throw new IOException("Cannot create output directory: " + String.valueOf(outDir));
        }
        NativeFS outFs = NativeFS.from(outDir).skipFileTypeCheck(true).atomicWrite(false).rejectSymlinks(false).build();
        FSUtils.CopyStats stats = FSUtils.newRecursiveSync().parallelism(8).overwriteMode(FSUtils.OverwriteMode.SKIP_UNLESS_HASH_CHANGED).from(files).to(outFs).run();
        System.out.println("[+] Sync files on disk: " + DKUtils.getElapsed((Stopwatch)sw) + " (" + stats.nbFilesCopied + " written, " + stats.nbFilesSkipped + " unchanged)");
    }

    public void addRootMapping(String inputDirectoryOrJar, String inputSourcesDirectory, String targetDirectory) {
        this.rootMappings.add(new ClassScanner.RootMapping(new File(this.inputDirectory, inputDirectoryOrJar), inputSourcesDirectory, targetDirectory));
    }

    abstract void translate() throws Exception;
}

