/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2;

import com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2.ExternalAccountCredentials;
import com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2.MetricsUtils;
import java.io.Serializable;

class ExternalAccountMetricsHandler
implements Serializable {
    private static final String SOURCE_KEY = "source";
    private static final String IMPERSONATION_KEY = "sa-impersonation";
    private static final String CONFIG_LIFETIME_KEY = "config-lifetime";
    private static final String BYOID_METRICS_SECTION = "google-byoid-sdk";
    private final boolean configLifetime;
    private final boolean saImpersonation;
    private String credentialSourceType;

    ExternalAccountMetricsHandler(ExternalAccountCredentials creds) {
        this.saImpersonation = creds.getServiceAccountImpersonationUrl() != null;
        this.configLifetime = creds.getServiceAccountImpersonationOptions().customTokenLifetimeRequested;
        this.credentialSourceType = creds.getCredentialSourceType();
    }

    String getExternalAccountMetricsHeader() {
        return String.format("%s %s %s/%s %s/%s %s/%s", MetricsUtils.getLanguageAndAuthLibraryVersions(), BYOID_METRICS_SECTION, SOURCE_KEY, this.credentialSourceType, IMPERSONATION_KEY, this.saImpersonation, CONFIG_LIFETIME_KEY, this.configLifetime);
    }
}

