/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.protocolPB;

import java.io.IOException;
import org.apache.hadoop.fs.FSProtos;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.StringInterner;

public final class PBHelper {
    private PBHelper() {
    }

    public static FsPermission convert(FSProtos.FsPermissionProto proto) throws IOException {
        return new FsPermission((short)proto.getPerm());
    }

    public static FSProtos.FsPermissionProto convert(FsPermission p) throws IOException {
        FSProtos.FsPermissionProto.Builder bld = FSProtos.FsPermissionProto.newBuilder();
        bld.setPerm(p.toShort());
        return bld.build();
    }

    public static FileStatus convert(FSProtos.FileStatusProto proto) throws IOException {
        short blockReplication;
        long length;
        long blocksize;
        Path symlink;
        boolean isdir;
        switch (proto.getFileType()) {
            case FT_DIR: {
                isdir = true;
                symlink = null;
                blocksize = 0L;
                length = 0L;
                blockReplication = 0;
                break;
            }
            case FT_SYMLINK: {
                isdir = false;
                symlink = new Path(proto.getSymlink());
                blocksize = 0L;
                length = 0L;
                blockReplication = 0;
                break;
            }
            case FT_FILE: {
                isdir = false;
                symlink = null;
                blocksize = proto.getBlockSize();
                length = proto.getLength();
                int brep = proto.getBlockReplication();
                if ((brep & 0xFFFF0000) != 0) {
                    throw new IOException(String.format("Block replication 0x%08x doesn't fit in 16 bits.", brep));
                }
                blockReplication = (short)brep;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + (Object)((Object)proto.getFileType()));
            }
        }
        Path path = new Path(proto.getPath());
        long mtime = proto.getModificationTime();
        long atime = proto.getAccessTime();
        FsPermission permission = PBHelper.convert(proto.getPermission());
        String owner = StringInterner.weakIntern(proto.getOwner());
        String group = StringInterner.weakIntern(proto.getGroup());
        int flags = proto.getFlags();
        FileStatus fileStatus = new FileStatus(length, isdir, blockReplication, blocksize, mtime, atime, permission, owner, group, symlink, path, FileStatus.attributes((flags & 1) != 0, (flags & 2) != 0, (flags & 4) != 0, (flags & 8) != 0));
        return fileStatus;
    }

    public static FSProtos.FileStatusProto convert(FileStatus stat) throws IOException {
        FSProtos.FileStatusProto.Builder bld = FSProtos.FileStatusProto.newBuilder();
        bld.setPath(stat.getPath().toString());
        if (stat.isDirectory()) {
            bld.setFileType(FSProtos.FileStatusProto.FileType.FT_DIR);
        } else if (stat.isSymlink()) {
            bld.setFileType(FSProtos.FileStatusProto.FileType.FT_SYMLINK).setSymlink(stat.getSymlink().toString());
        } else {
            bld.setFileType(FSProtos.FileStatusProto.FileType.FT_FILE).setLength(stat.getLen()).setBlockReplication(stat.getReplication()).setBlockSize(stat.getBlockSize());
        }
        bld.setAccessTime(stat.getAccessTime()).setModificationTime(stat.getModificationTime()).setOwner(stat.getOwner()).setGroup(stat.getGroup()).setPermission(PBHelper.convert(stat.getPermission()));
        int flags = 0;
        flags |= stat.hasAcl() ? 1 : 0;
        flags |= stat.isEncrypted() ? 2 : 0;
        flags |= stat.isErasureCoded() ? 4 : 0;
        bld.setFlags(flags |= stat.isSnapshotEnabled() ? 8 : 0);
        return bld.build();
    }
}

