/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.security.auth.MetaAuthService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPIAdminRolesAuditController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private AuditTrailService auditTrailService;

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/roles-audit/level-blueprint"}, method={RequestMethod.POST})
    public void auditBlueprintRoles(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try {
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx authCtx = this.authService.getTicketOrKey(req);
                this.permissionsService.checkMayManageGovern(authCtx);
            }
            JsonObject variables = (JsonObject)this.getRequestBodyAs(req, JsonObject.class);
            if (!variables.has("authIdentifier")) {
                throw ErrorContext.iae((String)"authIdentifier required");
            }
            if (!variables.has("blueprintId")) {
                throw ErrorContext.iae((String)"blueprintId required");
            }
            if (!variables.get("authIdentifier").isJsonPrimitive()) {
                throw ErrorContext.iae((String)"authIdentifier must be a string");
            }
            if (!variables.get("blueprintId").isJsonPrimitive()) {
                throw ErrorContext.iae((String)"blueprintId must be a string");
            }
            String authIdentifier = variables.get("authIdentifier").getAsString();
            String blueprintId = variables.get("blueprintId").getAsString();
            PublicAPIAdminRolesAuditController.writeJSON((HttpServletResponse)resp, (Object)this.rolesAndPermissionsService.auditAssignedRolesAndPermissionsCtxAtBlueprintLevel(authIdentifier, blueprintId));
            this.auditTrailService.generic("admin-roles-audit-level-blueprint").with("authIdentifier", authIdentifier).with("blueprintId", blueprintId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-roles-audit-level-blueprint", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/roles-audit/level-blueprint-version"}, method={RequestMethod.POST})
    public void auditBlueprintVersionRoles(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try {
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx authCtx = this.authService.getTicketOrKey(req);
                this.permissionsService.checkMayManageGovern(authCtx);
            }
            JsonObject variables = (JsonObject)this.getRequestBodyAs(req, JsonObject.class);
            if (!variables.has("authIdentifier")) {
                throw ErrorContext.iae((String)"authIdentifier required");
            }
            if (!variables.has("blueprintVersionId")) {
                throw ErrorContext.iae((String)"blueprintVersionId required");
            }
            if (!variables.get("authIdentifier").isJsonPrimitive()) {
                throw ErrorContext.iae((String)"authIdentifier must be a string");
            }
            String authIdentifier = variables.get("authIdentifier").getAsString();
            BlueprintVersionId blueprintVersionId = (BlueprintVersionId)JSON.parse((JsonElement)variables.get("blueprintVersionId"), BlueprintVersionId.class);
            PublicAPIAdminRolesAuditController.writeJSON((HttpServletResponse)resp, (Object)this.rolesAndPermissionsService.auditAssignedRolesAndPermissionsCtxAtBlueprintVersionLevel(authIdentifier, blueprintVersionId));
            this.auditTrailService.generic("admin-roles-audit-level-blueprint-version").with("authIdentifier", authIdentifier).with("blueprintId", blueprintVersionId.blueprintId).with("versionId", blueprintVersionId.versionId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-roles-audit-level-blueprint-version", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/roles-audit/level-artifact-existing"}, method={RequestMethod.POST})
    public void auditArtifactExistingRoles(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try {
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx authCtx = this.authService.getTicketOrKey(req);
                this.permissionsService.checkMayManageGovern(authCtx);
            }
            JsonObject variables = (JsonObject)this.getRequestBodyAs(req, JsonObject.class);
            if (!variables.has("authIdentifier")) {
                throw ErrorContext.iae((String)"authIdentifier required");
            }
            if (!variables.has("artifactId")) {
                throw ErrorContext.iae((String)"artifactId required");
            }
            if (!variables.get("authIdentifier").isJsonPrimitive()) {
                throw ErrorContext.iae((String)"authIdentifier must be a string");
            }
            if (!variables.get("artifactId").isJsonPrimitive()) {
                throw ErrorContext.iae((String)"artifactId must be a string");
            }
            String authIdentifier = variables.get("authIdentifier").getAsString();
            String artifactId = variables.get("artifactId").getAsString();
            PublicAPIAdminRolesAuditController.writeJSON((HttpServletResponse)resp, (Object)this.rolesAndPermissionsService.auditAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authIdentifier, artifactId));
            this.auditTrailService.generic("admin-roles-audit-level-artifact-existing").with("authIdentifier", authIdentifier).with("artifactId", artifactId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-roles-audit-level-artifact-existing", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/roles-audit/level-artifact-deleted"}, method={RequestMethod.POST})
    public void auditArtifactDeletedRoles(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try {
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx authCtx = this.authService.getTicketOrKey(req);
                this.permissionsService.checkMayManageGovern(authCtx);
            }
            JsonObject variables = (JsonObject)this.getRequestBodyAs(req, JsonObject.class);
            if (!variables.has("authIdentifier")) {
                throw ErrorContext.iae((String)"authIdentifier required");
            }
            if (!variables.has("artifactId")) {
                throw ErrorContext.iae((String)"artifactId required");
            }
            if (!variables.get("authIdentifier").isJsonPrimitive()) {
                throw ErrorContext.iae((String)"authIdentifier must be a string");
            }
            String authIdentifier = variables.get("authIdentifier").getAsString();
            String artifactId = variables.get("artifactId").getAsString();
            PublicAPIAdminRolesAuditController.writeJSON((HttpServletResponse)resp, (Object)this.rolesAndPermissionsService.auditAssignedRolesAndPermissionsCtxAtArtifactDeletedLevel(authIdentifier, artifactId));
            this.auditTrailService.generic("admin-roles-audit-level-artifact-deleted").with("authIdentifier", authIdentifier).with("artifactId", artifactId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-roles-audit-level-artifact-deleted", (Throwable)e).emit();
            throw e;
        }
    }
}

