/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.roles.Role;
import com.dataiku.gh.core.services.roles_and_permissions.roles.IAdminRolesService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PublicAPIAdminRolesController
extends PublicAPIControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IAdminRolesService adminRolesService;

    @AuditedCall(value={"msgType", "admin-roles-list"})
    @RequestMapping(value={"/publicapi/admin/roles"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPIAdminRolesController.writeJSON((HttpServletResponse)resp, this.adminRolesService.listRoles(authCtx));
    }

    @AuditedCall(value={"msgType", "admin-role-get", "roleId", "${roleId}"})
    @RequestMapping(value={"/publicapi/admin/role/{roleId}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String roleId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPIAdminRolesController.writeJSON((HttpServletResponse)resp, (Object)this.adminRolesService.getRole(authCtx, roleId));
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/roles"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.ROLE_CREATE)
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String newIdentifier) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            Role role = (Role)this.getRequestBodyAs(req, Role.class);
            Role createdRole = this.adminRolesService.createRole(authCtx, role, newIdentifier);
            this.auditTrailService.generic("admin-role-create").with("roleId", createdRole.id).emit();
            PublicAPIAdminRolesController.writeJSON((HttpServletResponse)resp, (Object)createdRole);
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-role-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/role/{roleId}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.ROLE_SAVE)
    public void save(HttpServletRequest req, HttpServletResponse resp, @PathVariable String roleId) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            Role role = (Role)this.getRequestBodyAs(req, Role.class);
            if (!StringUtils.equals((CharSequence)roleId, (CharSequence)role.id)) {
                throw new ValidationException("Role IDs do not match: " + roleId + " , " + role.id);
            }
            Role savedRole = this.adminRolesService.saveRole(authCtx, role);
            this.auditTrailService.generic("admin-role-save").with("roleId", savedRole.id).emit();
            PublicAPIAdminRolesController.writeJSON((HttpServletResponse)resp, (Object)savedRole);
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-role-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-role-delete", "roleId", "${roleId}"})
    @RequestMapping(value={"/publicapi/admin/role/{roleId}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.ROLE_DELETE)
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String roleId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.adminRolesService.deleteRole(authCtx, roleId);
        PublicAPIAdminRolesController.writeEmptyJSONObj((HttpServletResponse)resp);
    }
}

