/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.actions;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.gh.core.models.actions.InstanceAction;
import com.dataiku.gh.core.services.actions.IAdminActionService;
import com.dataiku.gh.core.services.actions.IInstanceActionsDataService;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.IInstanceActionValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminActionService
implements IAdminActionService {
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IInstanceActionsDataService instanceActionsDataService;
    @Autowired
    private IInstanceActionValidationService instanceActionValidationService;

    @Override
    @GHWriteTransaction
    public InstanceAction createInstanceAction(AuthCtx authCtx, InstanceAction instanceAction, String newIdentifier) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.licenseEnforcementService.checkGovernActionDesignerAllowed();
        this.permissionsService.checkMayManageGovern(authCtx);
        if (instanceAction.id != null) {
            throw new ValidationException("instanceAction.id `" + instanceAction.id + "` cannot be set in creation");
        }
        instanceAction.id = IdentifiersUtils.buildInstanceActionId(newIdentifier);
        this.instanceActionValidationService.validateInstanceAction(instanceAction);
        return this.instanceActionsDataService.createInstanceAction(instanceAction);
    }

    @Override
    @GHWriteTransaction
    public InstanceAction saveInstanceAction(AuthCtx authCtx, InstanceAction instanceAction) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.licenseEnforcementService.checkGovernActionDesignerAllowed();
        this.permissionsService.checkMayManageGovern(authCtx);
        this.instanceActionValidationService.validateInstanceAction(instanceAction);
        return this.instanceActionsDataService.saveInstanceAction(instanceAction);
    }

    @Override
    @GHWriteTransaction
    public void deleteInstanceAction(AuthCtx authCtx, String instanceActionId) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        this.permissionsService.checkMayManageGovern(authCtx);
        this.instanceActionsDataService.deleteInstanceAction(instanceActionId);
    }
}

