/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.relationships;

import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.relationships.Relationship;
import com.dataiku.gh.core.services.relationships.IRelationshipsService;
import com.dataiku.gh.core.services.relationships.collectors.CollectorResult;
import com.dataiku.gh.core.services.relationships.collectors.RelationshipsCollector;
import com.dataiku.gh.core.services.relationships.handlers.IRelationshipHandler;
import com.dataiku.gh.core.services.relationships.handlers.RelationshipValidationContext;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RelationshipsService
implements IRelationshipsService {
    @Autowired
    private List<IRelationshipHandler<? extends Relationship>> relationshipHandlers;

    @Override
    public CollectorResult collectRelationships(EnrichedArtifact enrichedArtifact) {
        RelationshipsCollector collector = new RelationshipsCollector(enrichedArtifact.artifact);
        enrichedArtifact.accept(collector);
        return collector.result;
    }

    @Override
    @GHReadonlyTransaction
    public void validateRelationships(EnrichedArtifact enrichedArtifact) throws IOException {
        CollectorResult collectorResult = this.collectRelationships(enrichedArtifact);
        RelationshipValidationContext relationshipValidationContext = RelationshipValidationContext.builder(collectorResult.artifactIdsAllowedBlueprintIds);
        for (IRelationshipHandler<? extends Relationship> handler : this.relationshipHandlers) {
            handler.validateRelationships(collectorResult.getRelationships(handler.getRelationshipClazz()), relationshipValidationContext);
        }
    }

    @Override
    @GHReadonlyTransaction
    public List<Relationship> getRelationshipsForArtifactId(String artifactId) throws IOException {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (IRelationshipHandler<? extends Relationship> handler : this.relationshipHandlers) {
            relationships.addAll(handler.getRelationshipsForArtifactId(artifactId));
        }
        return relationships;
    }

    @Override
    @GHWriteTransaction
    public void createRelationships(CollectorResult collectorResult) throws IOException {
        for (IRelationshipHandler<? extends Relationship> handler : this.relationshipHandlers) {
            handler.createRelationships(collectorResult.getRelationships(handler.getRelationshipClazz()));
        }
    }

    @Override
    @GHWriteTransaction
    public void saveRelationships(CollectorResult collectorResult) throws IOException {
        for (IRelationshipHandler<? extends Relationship> handler : this.relationshipHandlers) {
            handler.saveRelationships(collectorResult.getRelationships(handler.getRelationshipClazz()));
        }
    }

    @Override
    @GHWriteTransaction
    public void deleteRelationships(CollectorResult collectorResult) throws IOException {
        for (IRelationshipHandler<? extends Relationship> handler : this.relationshipHandlers) {
            handler.deleteRelationships(collectorResult.getRelationships(handler.getRelationshipClazz()));
        }
    }
}

