/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.services.AliveService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/admin"})
public class PublicAPIIsAliveController
extends PublicAPIControllerBase {
    @Autowired
    private AliveService aliveService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;

    @RequestMapping(value={"/isAlive"}, method={RequestMethod.GET})
    @ResponseBody
    public void isAlive(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AliveService.AlivenessStatus status = this.aliveService.isAlive();
        if (status.alive) {
            PublicAPIIsAliveController.writeJSON((HttpServletResponse)resp, (Object)status);
        } else {
            resp.setStatus(503);
            PublicAPIIsAliveController.writeJSON((HttpServletResponse)resp, (Object)status);
        }
    }

    @RequestMapping(value={"/set-not-alive"}, method={RequestMethod.PUT})
    public void setNotAlive(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        this.aliveService.setNotAlive();
    }

    @RequestMapping(value={"/set-alive"}, method={RequestMethod.PUT})
    public void setAlive(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        this.aliveService.setAlive();
    }

    @RequestMapping(value={"/projects/{projectKey}/isAlive"}, method={RequestMethod.GET})
    @ResponseBody
    public void isProjectAlive(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AliveService.AlivenessStatus status = this.aliveService.isProjectAlive(projectKey);
        if (status.alive) {
            PublicAPIIsAliveController.writeJSON((HttpServletResponse)resp, (Object)status);
        } else {
            resp.setStatus(503);
            PublicAPIIsAliveController.writeJSON((HttpServletResponse)resp, (Object)status);
        }
    }

    @RequestMapping(value={"/projects/{projectKey}/set-not-alive"}, method={RequestMethod.PUT})
    public void setProjectNotAlive(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        this.aliveService.setProjectNotAlive(projectKey);
    }

    @RequestMapping(value={"/projects/{projectKey}/set-alive"}, method={RequestMethod.PUT})
    public void setProjectAlive(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        this.aliveService.setProjectAlive(projectKey);
    }
}

