/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.datasets.DatasetReadAPIUtils;
import com.dataiku.dip.server.services.SQLQueryStreamService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi/sql"})
public class PublicAPISQLController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private SQLQueryStreamService service;
    @Autowired
    private AuditTrailService auditTrailService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.sql");

    private void start_(HttpServletRequest req, HttpServletResponse resp, SQLQueryStreamService.SQLQueryRequest queryRequest) throws Exception {
        AbstractSQLConnection connection;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            String dbType;
            boolean hasDataset;
            authCtx = this.authService.getTicketOrKey(req);
            boolean hasConnection = !StringUtils.isBlank((String)queryRequest.connection);
            boolean hasDatabase = !StringUtils.isBlank((String)queryRequest.database);
            boolean bl = hasDataset = !StringUtils.isBlank((String)queryRequest.datasetFullName);
            if (queryRequest.type.equalsIgnoreCase("sql")) {
                dbType = "sql";
                if (hasDatabase) {
                    throw new Exception("Specify dataset or connection for sql queries");
                }
                if (hasConnection && hasDataset) {
                    throw new Exception("Only one of connection or dataset can be specified");
                }
                if (!hasConnection && !hasDataset) {
                    throw new Exception("At least one of connection or dataset must be specified");
                }
            } else if (queryRequest.type.equalsIgnoreCase("hive")) {
                dbType = "hive-jdbc";
                if (hasConnection && hasDataset || hasConnection && hasDatabase || hasDatabase && hasDataset) {
                    throw new Exception("Only one of connection or dataset or database can be specified");
                }
                if (!(hasConnection || hasDataset || hasDatabase)) {
                    throw new Exception("At least one of connection or dataset or database must be specified");
                }
            } else if (queryRequest.type.equalsIgnoreCase("impala")) {
                dbType = "impala-jdbc";
                if (hasConnection && hasDataset || hasConnection && hasDatabase || hasDatabase && hasDataset) {
                    throw new Exception("Only one of connection or dataset or database can be specified");
                }
                if (!(hasConnection || hasDataset || hasDatabase)) {
                    throw new Exception("At least one of connection or dataset or database must be specified");
                }
            } else if (queryRequest.type.equalsIgnoreCase("spark")) {
                dbType = "spark-livy";
                if (hasConnection && hasDataset || hasConnection && hasDatabase || hasDatabase && hasDataset) {
                    throw new Exception("Only one of connection or dataset or database can be specified");
                }
                if (!(hasConnection || hasDataset || hasDatabase)) {
                    throw new Exception("At least one of connection or dataset or database must be specified");
                }
            } else {
                throw new Exception("Unknown sql type '" + queryRequest.type + "', should be among {sql, hive, impala, spark}");
            }
            if (queryRequest.connection != null && queryRequest.connection.length() > 0) {
                if (dbType.equals("hive-jdbc") || dbType.equals("impala-jdbc") || dbType.equals("spark-livy")) {
                    queryRequest.connection = "@virtual(" + dbType + "):connection:" + queryRequest.connection;
                }
            } else {
                if (queryRequest.datasetFullName != null && queryRequest.datasetFullName.length() > 0) {
                    DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveFull((String)queryRequest.datasetFullName);
                    SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory((AnyLoc)datasetLoc);
                    if (DatasetInspector.canHiveTable((SerializedDataset)sd)) {
                        queryRequest.database = HiveSchemaHandler.getResolvedHiveTableRefFromDataset((Dataset)Dataset.fromSerialized((SerializedDataset)sd)).getSchemaNullIfBlank();
                        if (queryRequest.database == null) {
                            throw new Exception("The hive database is not configured on the connection of dataset " + sd.name);
                        }
                        queryRequest.connection = "@virtual(" + dbType + "):" + queryRequest.database;
                    } else if (sd.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
                        queryRequest.connection = ((AbstractSQLDatasetHandler.AbstractSQLConfig)sd.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class)).connection;
                    }
                    throw new Exception("Dataset " + queryRequest.connection + " is neither of SQL nor HDFS type.");
                }
                queryRequest.connection = "@virtual(" + dbType + "):" + queryRequest.database;
            }
            connection = (AbstractSQLConnection)ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, queryRequest.connection, AbstractSQLConnection.class);
            this.permissionsService.checkSQLikePrivilege(authCtx, (DSSConnection)connection);
        }
        AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode = queryRequest.datetimenotzReadMode;
        AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode = queryRequest.dateonlyReadMode;
        if (queryRequest.readTimestampWithoutTimezoneAsString != null) {
            AbstractSQLDatasetHandler.ReadTemporalMode readTemporalMode = datetimenotzReadMode = queryRequest.readTimestampWithoutTimezoneAsString == true ? AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING : AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE;
        }
        if (queryRequest.readDateAsString != null) {
            dateonlyReadMode = queryRequest.readDateAsString == true ? AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING : AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE;
        }
        SQLQueryStreamService.SQLStreamingSessionInfo info = this.service.startStreamingSQLQuery(connection, queryRequest.query, queryRequest.preQueries, queryRequest.postQueries, queryRequest.extraConf, queryRequest.scriptSteps, queryRequest.scriptInputSchema, queryRequest.scriptOutputSchema, queryRequest.scriptReportLocation, authCtx, datetimenotzReadMode, dateonlyReadMode, queryRequest.projectKey);
        this.auditTrailService.generic("sql-query-started").with("connection", connection.name).with("query", queryRequest.query).with("queryId", info.queryId).emit();
        PublicAPISQLController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditInline
    @RequestMapping(value={"/queries/"}, method={RequestMethod.POST})
    public void startStreaming(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        SQLQueryStreamService.SQLQueryRequest qreq = (SQLQueryStreamService.SQLQueryRequest)this.getRequestBodyAs(req, SQLQueryStreamService.SQLQueryRequest.class);
        this.start_(req, resp, qreq);
    }

    @AuditInline
    @RequestMapping(value={"/queries/{queryId}/stream"}, method={RequestMethod.GET})
    public void stream(HttpServletRequest req, HttpServletResponse resp, @PathVariable String queryId, @RequestParam(value="format", defaultValue="json") String format, @RequestParam(value="formatParams", defaultValue="") String formatParams) throws Exception {
        AuthCtx authCtx;
        DSSConnection connInfo = this.service.getConnection(queryId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkSQLikePrivilege(authCtx, connInfo);
        }
        this.auditTrailService.generic("sql-query-fetch").with("queryId", queryId).emit();
        this.service.streamSQLQuery(resp, authCtx, queryId, DatasetReadAPIUtils.getFormatDef((String)format, (JsonObject)DatasetReadAPIUtils.formatParamsFromString((String)formatParams)));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/queries/{queryId}/finish-streaming"}, method={RequestMethod.GET})
    public void finishStreaming(HttpServletRequest req, HttpServletResponse resp, @PathVariable String queryId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getTicketOrKey(req);
        }
        this.service.verifySQLQuery(queryId);
        resp.setStatus(200);
    }
}

