/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.APIIllegalArgumentException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.scenarios.TestingStatus;
import com.dataiku.dip.scheduler.steps.PytestStepRunner;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPICodes;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.api.PublicAPIJobsController;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.controllers.ScenarioController;
import com.dataiku.dip.server.services.ScenarioReportsService;
import com.dataiku.dip.server.services.ScenarioRunsService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import freemarker.template.TemplateException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/scenarios"})
public class PublicAPIScenariosController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private ScenarioRunsService scenarioRunsService;
    @Autowired
    private ScenariosTriggerService scenariosTriggerService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private ScenarioReportsService scenarioReportsService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.jobs");

    private Scenario.ScenarioListItem makeHead(Scenario scenario) {
        Scenario.ScenarioListItem scenarioWithStatus = new Scenario.ScenarioListItem(scenario);
        ScenarioThread scenarioThread = this.scenarioRunsService.getMostRecentScenarioRun(scenario);
        scenarioWithStatus.setThread(scenarioThread, false);
        return scenarioWithStatus;
    }

    @AuditedCall(value={"msgType", "scenarios-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        ArrayList ret = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List scenarios = this.scenariosService.list(projectKey);
            for (Scenario scenario : scenarios) {
                ret.add(this.makeHead(scenario));
            }
        }
        for (Scenario.ScenarioListItem item : ret) {
            item.computeTriggerDigest_NT(this.scenariosTriggerService);
        }
        PublicAPIScenariosController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "scenario-get", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/{scenarioId:.+}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String scenarioId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            Scenario scenario = this.scenariosService.getMandatoryUnsafe(projectKey, scenarioId);
            PublicAPIScenariosController.writeJSON((HttpServletResponse)resp, (Object)scenario);
        }
    }

    @AuditedCall(value={"msgType", "scenario-delete", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/{scenarioId:.+}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String scenarioId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.scenariosService.getMandatoryUnsafe(projectKey, scenarioId);
        }
        String message = "Deleted scenario " + scenarioId + " from project " + projectKey;
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.scenariosService.delete(projectKey, scenarioId);
            t.commit(message);
        }
        this.writeMessage(resp, message, new Object[0]);
    }

    @AuditedCall(value={"msgType", "scenario-get", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/{scenarioId}/light"}, method={RequestMethod.GET})
    public void getNoParams(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String scenarioId) throws Exception {
        Scenario.ScenarioListItem ret;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            Scenario scenario = this.scenariosService.getMandatoryUnsafe(projectKey, scenarioId);
            ret = this.makeHead(scenario);
        }
        ret.computeTriggerDigest_NT(this.scenariosTriggerService);
        PublicAPIScenariosController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "scenario-get", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/{scenarioId}/payload"}, method={RequestMethod.GET})
    public void getPayload(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String scenarioId, @RequestParam(required=false, defaultValue="py") String extension) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            ScenarioController.ScenarioPayload scenarioPayload = new ScenarioController.ScenarioPayload();
            scenarioPayload.script = this.scenariosService.getPayload(projectKey, scenarioId, extension);
            PublicAPIScenariosController.writeJSON((HttpServletResponse)resp, (Object)scenarioPayload);
        }
    }

    @AuditedCall(value={"msgType", "scenario-run-abort", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/{scenarioId}/abort"}, method={RequestMethod.POST})
    public void abort(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scenarioId, @PathVariable String projectKey) throws DKUSecurityException, IOException {
        PublicAPIControllerBase.ResponseMessage ret;
        Scenario scenario;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.RUN_SCENARIOS});
            scenario = this.scenariosService.getMandatoryUnsafe(projectKey, scenarioId);
        }
        ScenarioThread scenarioThread = this.scenarioRunsService.getMostRecentScenarioRun(scenario);
        if (scenarioThread == null) {
            ret = new PublicAPIControllerBase.ResponseMessage("the scenario is not running");
        } else if (!scenarioThread.isAlive()) {
            ret = new PublicAPIControllerBase.ResponseMessage("the scenario is not running anymore");
        } else if (scenarioThread.isAborted()) {
            ret = new PublicAPIControllerBase.ResponseMessage("the scenario has already been aborted");
        } else {
            ret = new PublicAPIControllerBase.ResponseMessage("abort requested");
            scenarioThread.abort("Aborted from public API");
        }
        PublicAPIScenariosController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void create(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        String fullName;
        Scenario scenario = (Scenario)this.getRequestBodyAs(req, Scenario.class);
        this.require(StringUtils.isNotBlank((String)scenario.getName()), "Required field 'name' is missing.");
        this.require(scenario.getParams() != null, "Required field 'params' is missing.");
        if (StringUtils.isBlank((String)scenario.getProjectKey())) {
            scenario.withProjectKey(projectKey);
        } else if (!projectKey.equals(scenario.getProjectKey())) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Project key " + scenario.getProjectKey() + " from scenario doesn't match project key " + projectKey + " from call");
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            scenario = this.scenariosService.create(scenario.projectKey, scenario);
            fullName = projectKey + "." + scenario.getId();
            t.commit("Created scenario " + fullName);
        }
        this.scenariosTriggerService.touchTriggerThreadExecution();
        this.auditTrailService.generic("scenario-create").with("fullName", fullName).with("type", scenario.getType()).emit();
        Scenario.ScenarioListItem ret = this.makeHead(scenario);
        ret.computeTriggerDigest_NT(this.scenariosTriggerService);
        PublicAPIScenariosController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "scenario-save", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/{scenarioId:.+}"}, method={RequestMethod.PUT})
    public void update(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String scenarioId) throws Exception {
        Scenario scenario = (Scenario)this.getRequestBodyAs(req, Scenario.class);
        this.require(StringUtils.isNotBlank((String)scenario.getName()), "Required field 'name' is missing.");
        this.require(scenario.getParams() != null, "Required field 'params' is missing.");
        if (StringUtils.isBlank((String)scenario.getProjectKey())) {
            scenario.withProjectKey(projectKey);
        } else if (!projectKey.equals(scenario.getProjectKey())) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Project key " + scenario.getProjectKey() + " from scenario doesn't match project key " + projectKey + " from call");
        }
        if (StringUtils.isBlank((String)scenario.getId())) {
            scenario.withId(scenarioId);
        } else if (!scenarioId.equals(scenario.getId())) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Scenario id " + scenario.getId() + " from scenario doesn't match id " + scenarioId + " from call");
        }
        String fullName = projectKey + "." + scenarioId;
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.scenariosService.save(projectKey, scenario);
            t.commit("Updated scenario " + fullName);
        }
        this.scenariosTriggerService.touchTriggerThreadExecution();
        this.writeMessage(resp, "Updated scenario %s", new Object[]{fullName});
    }

    @AuditedCall(value={"msgType", "scenario-save", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/{scenarioId}/light"}, method={RequestMethod.PUT})
    public void updateNoParams(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String scenarioId) throws Exception {
        Scenario scenario = (Scenario)this.getRequestBodyAs(req, Scenario.class);
        this.require(StringUtils.isNotBlank((String)scenario.getName()), "Required field 'name' is missing.");
        if (StringUtils.isBlank((String)scenario.getProjectKey())) {
            scenario.withProjectKey(projectKey);
        } else if (!projectKey.equals(scenario.getProjectKey())) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Project key " + scenario.getProjectKey() + " from scenario doesn't match project key " + projectKey + " from call");
        }
        if (StringUtils.isBlank((String)scenario.getId())) {
            scenario.withId(scenarioId);
        } else if (!scenarioId.equals(scenario.getId())) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Scenario id " + scenario.getId() + " from scenario doesn't match id " + scenarioId + " from call");
        }
        String fullName = projectKey + "." + scenarioId;
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.scenariosService.saveNoParams(projectKey, scenario, Arrays.asList("active", "checklists", "description", "shortDesc", "tags", "customFields"));
            t.commit("Updated scenario " + fullName);
        }
        this.scenariosTriggerService.touchTriggerThreadExecution();
        this.writeMessage(resp, "Updated scenario %s", new Object[]{fullName});
    }

    @AuditedCall(value={"msgType", "scenario-save", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/{scenarioId}/payload"}, method={RequestMethod.PUT})
    public void updatePayload(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String scenarioId, @RequestParam(required=false, defaultValue="py") String extension) throws Exception {
        ScenarioController.ScenarioPayload payload = (ScenarioController.ScenarioPayload)this.getRequestBodyAs(req, ScenarioController.ScenarioPayload.class);
        this.require(StringUtils.isNotBlank((String)payload.script), "Required field 'script' is missing.");
        String fullName = projectKey + "." + scenarioId;
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.scenariosService.savePayload(projectKey, scenarioId, extension, payload.script);
            t.commit("Updated scenario payload " + fullName);
        }
        this.writeMessage(resp, "Updated scenario payload %s", new Object[]{fullName});
    }

    @AuditedCall(value={"msgType", "scenario-run", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/{scenarioId}/run"}, method={RequestMethod.POST})
    public void start(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scenarioId, @PathVariable String projectKey) throws IOException, SQLException, Exception {
        Scenario scenario;
        DSSAuthCtx authCtx;
        byte[] bodyData = this.getRequestBodyData(req);
        JsonObject params = new JsonObject();
        if (bodyData.length > 0) {
            params = (JsonObject)JSON.parse((InputStream)new ByteArrayInputStream(bodyData), JsonObject.class);
        }
        try (Transaction t = this.transactionService.beginRead();){
            boolean otherTriggers;
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.RUN_SCENARIOS});
            LicenseStatusService.LicensingStatus licenseStatus = this.licenseStatusService.getLicensingStatus();
            AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus features = this.licenseEnforcementService.getFeaturesStatus();
            boolean temporalTrigger = features.temporalTriggerAllowed || licenseStatus.ceEntrepriseTrial;
            boolean bl = otherTriggers = features.allScenarioTriggersAllowed || licenseStatus.ceEntrepriseTrial;
            if (!temporalTrigger && !otherTriggers) {
                throw new LicenseRestrictionException("Automated triggering of scenarios is not available in your license");
            }
            scenario = this.scenariosService.getMandatoryUnsafe(projectKey, scenarioId);
            if (StringUtils.isBlank((String)scenario.runAsUser)) {
                this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            }
        }
        TriggerFire triggerFire = this.scenariosTriggerService.manualRun(authCtx, scenario, "API run", params);
        PublicAPIScenariosController.writeJSON((HttpServletResponse)resp, (Object)triggerFire);
    }

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/{scenarioId}/get-last-runs"}, method={RequestMethod.GET})
    public void getLastRuns(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scenarioId, @PathVariable String projectKey, @RequestParam(required=false, defaultValue="10") int limit, @RequestParam(required=false, defaultValue="false") boolean onlyFinishedRuns) throws IOException, SQLException, Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            PublicAPIScenariosController.writeJSON((HttpServletResponse)resp, (Object)this.scenariosService.getLastRuns(projectKey, scenarioId, limit, onlyFinishedRuns));
        }
    }

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/{scenarioId}/get-runs-by-date"}, method={RequestMethod.GET})
    public void getRunsByDate(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scenarioId, @PathVariable String projectKey, @RequestParam(value="fromDate") String fromDateStr, @RequestParam(value="toDate") String toDateStr) throws Exception {
        DateTimeFormatter parser = ISODateTimeFormat.dateParser();
        DateTime fromDate = parser.parseDateTime(fromDateStr);
        DateTime toDate = parser.parseDateTime(toDateStr);
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        PublicAPIScenariosController.writeJSON((HttpServletResponse)resp, (Object)this.scenariosService.getRunsByDate(projectKey, scenarioId, fromDate, toDate));
    }

    @AuditedCall(value={"msgType", "scenarios-get-history", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/get-outcomes"})
    public void getOutcomes(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(value="fromDate") String fromDateStr, @RequestParam(value="toDate") String toDateStr, @RequestParam(required=false, defaultValue="false") boolean includeOutOfDatesScenarios) throws Exception {
        List scenarios;
        DateTimeFormatter parser = ISODateTimeFormat.dateParser();
        DateTime fromDate = parser.parseDateTime(fromDateStr);
        DateTime toDate = parser.parseDateTime(toDateStr);
        logger.info((Object)("Collecting info for scenarios in the time range " + fromDateStr + " / " + toDateStr));
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(this.authService.getTicketOrKey(req), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            scenarios = this.scenariosService.listUnsafe(projectKey);
        }
        PublicAPIScenariosController.writeJSON((HttpServletResponse)resp, (Object)this.scenarioReportsService.getDayReport_NT(fromDate, toDate, scenarios, includeOutOfDatesScenarios));
    }

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/{scenarioId}/get-run-for-trigger"}, method={RequestMethod.GET})
    public void getRunOfTrigger(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scenarioId, @PathVariable String projectKey, @RequestParam String triggerId, @RequestParam String triggerRunId) throws IOException, SQLException, Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        PublicAPIScenariosController.writeJSON((HttpServletResponse)resp, (Object)this.scenariosService.getScenarioRunStartedByTriggerFire(projectKey, scenarioId, triggerId, triggerRunId));
    }

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}", "runId", "${runId}"})
    @RequestMapping(value={"/{scenarioId}/{runId}/"}, method={RequestMethod.GET})
    public void getRun(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scenarioId, @PathVariable String projectKey, @PathVariable String runId) throws DKUSecurityException, SQLException, IOException {
        boolean includeLogs;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            includeLogs = PublicAPIJobsController.canAccessLogs(authCtx);
        }
        PublicAPIScenariosController.writeJSON((HttpServletResponse)resp, (Object)this.scenariosService.getScenarioRunDetails(projectKey, scenarioId, runId, includeLogs));
    }

    @AuditedCall(value={"msgType", "scenario-get-run-report", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}", "runId", "${runId}"})
    @RequestMapping(value={"/{scenarioId}/{runId}/scenario-run-report"}, method={RequestMethod.GET})
    @ResponseBody
    public void downloadScenarioRunReport(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String scenarioId, @PathVariable String runId) throws IOException, DKUSecurityException, SQLException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        ScenariosService.ScenarioRunDetails runDetails = this.scenariosService.getScenarioRunDetails(projectKey, scenarioId, runId, false);
        if (runDetails.scenarioRun == null) {
            resp.setStatus(404);
            resp.getWriter().write(String.format("Run %s of scenario %s not found", runId, scenarioId));
            return;
        }
        String reportFileStem = String.format("%s-%s-test-scenario-report", scenarioId, runId);
        String reportFileName = String.format("%s.xml", reportFileStem);
        try (AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"test-reports", (String)reportFileStem, (String)"xml");){
            this.scenariosService.createTestScenarioRunReportFile(runDetails.scenarioRun, runDetails.stepRuns, (File)tmpFile);
            this.writeFileForDownload(resp, (File)tmpFile, "application/xml", reportFileName);
        }
    }

    @AuditedCall(value={"msgType", "scenario-get-step-run-report", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}", "runId", "${runId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/{scenarioId}/{runId}/step-run-report"}, method={RequestMethod.GET})
    @ResponseBody
    public void downloadStepRunReport(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String scenarioId, @PathVariable String runId, @RequestParam String stepId) throws IOException, DKUSecurityException, SQLException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        ScenariosService.ScenarioRunDetails runDetails = this.scenariosService.getScenarioRunDetails(projectKey, scenarioId, runId, false);
        if (Objects.isNull(runDetails.scenarioRun)) {
            resp.setStatus(404);
            resp.getWriter().write(String.format("Run %s of scenario %s not found", runId, scenarioId));
            return;
        }
        StepRun stepRun = runDetails.stepRuns.stream().filter(sr -> sr.getStep().getId().equals(stepId)).findFirst().orElse(null);
        if (Objects.isNull(stepRun)) {
            resp.setStatus(404);
            resp.getWriter().write(String.format("Step %s was not run in run %s of scenario %s", stepId, runId, scenarioId));
            return;
        }
        if (!PytestStepRunner.META.getType().equals(stepRun.getStep().getType())) {
            resp.setStatus(404);
            resp.getWriter().write("Step run reports are only available for Python Unit Test steps");
            return;
        }
        ReportItem.RanPythonUnitTest ranPythonUnitTest = this.scenariosService.findRanPythonUnitTestItem(stepRun.getAdditionalReportItems()).orElse(null);
        if (Objects.isNull(ranPythonUnitTest) || StringUtils.isEmpty((String)ranPythonUnitTest.getRunReport())) {
            resp.setStatus(404);
            resp.getWriter().write(String.format("No report file found for step %s in run %s of scenario %s", stepId, runId, scenarioId));
            return;
        }
        String xmlReport = ranPythonUnitTest.getRunReport();
        this.writeStream(resp, new ByteArrayInputStream(xmlReport.getBytes(StandardCharsets.UTF_8)), "application/xml", String.format("step-run-report-%s-%s-%s.xml", scenarioId, runId, stepRun.getStep().getName()));
    }

    @AuditedCall(value={"msgType", "get-last-test-scenario-runs-report", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/last-test-scenario-runs-report"}, method={RequestMethod.GET})
    public void downloadLastTestScenarioRunsReport(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(required=false) String bundleId) throws DKUSecurityException, IOException, SQLException {
        if (StringUtils.isNotBlank((String)bundleId) && ApplicationConfigurator.getNodeType() != ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Specifying a Bundle ID is supported only for Automation Nodes");
        }
        if (StringUtils.isBlank((String)bundleId) && ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            try {
                bundleId = CommonBundleUtils.getActiveBundleId((String)projectKey);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Failed to retrieve the active bundle on project %s", projectKey));
            }
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        String reportFileStem = String.format("%s-%s-test-scenarios-report", projectKey, bundleId);
        String reportFileName = String.format("%s.xml", reportFileStem);
        try (AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"test-reports", (String)reportFileStem, (String)"xml");){
            if (bundleId != null) {
                this.scenariosService.createTestScenarioRunsReportFileForBundle(projectKey, bundleId, (File)tmpFile);
            } else {
                this.scenariosService.createTestScenarioRunsReportFileForProject(projectKey, (File)tmpFile);
            }
            this.writeFileForDownload(resp, (File)tmpFile, "application/xml", reportFileName);
        }
    }

    @AuditedCall(value={"msgType", "get-last-test-scenario-runs-html-report", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/last-test-scenario-runs-html-report"}, method={RequestMethod.GET})
    public void downloadLastTestScenarioRunsHTMLReport(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(required=false) String bundleId) throws DKUSecurityException, IOException, SQLException, TemplateException {
        String nodeId;
        String userName;
        if (StringUtils.isNotBlank((String)bundleId) && ApplicationConfigurator.getNodeType() != ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Specifying a Bundle ID is supported only for Automation Nodes");
        }
        if (StringUtils.isBlank((String)bundleId) && ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            try {
                bundleId = CommonBundleUtils.getActiveBundleId((String)projectKey);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Failed to retrieve the active bundle on project %s", projectKey));
            }
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            userName = authCtx.getDSSUserForImpersonation();
            nodeId = ApplicationConfigurator.getNodeId();
        }
        String reportFileStem = String.format("%s-%s-test-scenarios-report", projectKey, bundleId);
        String reportFileName = String.format("%s.html", reportFileStem);
        try (AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"test-reports", (String)reportFileStem, (String)"html");){
            this.scenariosService.createTestScenarioRunsHTMLReportFile(projectKey, bundleId, nodeId, userName, (File)tmpFile);
            this.writeFileForDownload(resp, (File)tmpFile, "text/html", reportFileName);
        }
    }

    @AuditedCall(value={"msgType", "get-testing-status", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/testing-status"}, method={RequestMethod.GET})
    @ResponseBody
    public TestingStatus getTestingStatus(HttpServletRequest req, @PathVariable String projectKey, @RequestParam(required=false) String bundleId) throws DKUSecurityException, SQLException, IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        if (StringUtils.isNotBlank((String)bundleId) && ApplicationConfigurator.getNodeType() != ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Specifying a Bundle ID is supported only for Automation Nodes");
        }
        return this.scenariosService.getTestingStatus(projectKey, bundleId);
    }

    @AuditedCall(value={"msgType", "run-test-scenarios", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/run-test-scenarios"}, method={RequestMethod.POST})
    @ResponseBody
    public TestingStatus runTestScenarios(HttpServletRequest req, @PathVariable @Nonnull String projectKey) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.RUN_SCENARIOS});
        }
        return this.scenariosService.runTestScenarios_NT(authCtx, projectKey);
    }

    @AuditedCall(value={"msgType", "scenario-get-trigger", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}", "triggerId", "${triggerId}", "triggerRunId", "{triggerRunId}"})
    @RequestMapping(value={"/trigger/{scenarioId}/{triggerId}"}, method={RequestMethod.GET})
    public void getTriggerOfScenario(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scenarioId, @PathVariable String projectKey, @PathVariable String triggerId, @RequestParam String triggerRunId) throws DKUSecurityException, SQLException, IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        PublicAPIScenariosController.writeJSON((HttpServletResponse)resp, (Object)this.scenariosTriggerService.getTriggerFire(projectKey, scenarioId, triggerId, triggerRunId));
    }

    @AuditedCall(value={"msgType", "scenario-get-log", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}", "runId", "${runId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/{scenarioId}/{runId}/log"}, method={RequestMethod.GET})
    public void getLogs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String scenarioId, @PathVariable String runId, @RequestParam(defaultValue="") String stepId) throws Exception {
        ScenariosService.ScenarioRunDetails runDetails;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            if (!PublicAPIJobsController.canAccessLogs(authCtx)) {
                throw new UnauthorizedException("Access denied", "Logs visibility is restricted. Contact your administrator if you need to access these logs");
            }
            runDetails = this.scenariosService.getScenarioRunDetails(projectKey, scenarioId, runId, false);
            if (runDetails.scenarioRun == null) {
                throw new NotFoundException(String.format("Run %s of scenario %s not found", runId, scenarioId));
            }
        }
        File log = ScenarioRunContext.getLogFile((ScenariosService.ScenarioRunDetails)runDetails, (String)stepId);
        if (log == null) {
            throw new NotFoundException(String.format("Step %s was not run in run %s of scenario %s", stepId, runId, scenarioId));
        }
        log = DKUFileUtils.getWithAutoDecompress((File)log);
        this.writeFileWithAutoDecompress(resp, log, "text/plain");
    }
}

