/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.modelevaluation;

import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.checks.Check;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class ChecksResolver {
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.modelevaluation");

    @Nonnull
    public static ChecksSet resolve(String jsonBody, ModelEvaluationStore mes) {
        JsonElement root = (JsonElement)JSON.parse((String)jsonBody, JsonElement.class);
        if (root.isJsonArray()) {
            List requestedCheckLabels = (List)JSON.parse((String)jsonBody, (TypeToken)new TypeToken<List<String>>(){});
            return ChecksResolver.buildChecksSetFromLabels(requestedCheckLabels, mes);
        }
        return (ChecksSet)JSON.parse((String)jsonBody, ChecksSet.class);
    }

    @Nonnull
    private static ChecksSet buildChecksSetFromLabels(List<String> requestedCheckLabels, ModelEvaluationStore mes) {
        assert (mes.metricsChecks != null) : "No checks configuration found in the Model Evaluation Store.";
        if (requestedCheckLabels.isEmpty()) {
            logger.info((Object)"No specific check labels requested. Using default checks configuration.");
            return mes.metricsChecks;
        }
        ChecksSet checksSet = new ChecksSet();
        HashSet<String> foundLabels = new HashSet<String>();
        HashSet<String> requestedSet = new HashSet<String>(requestedCheckLabels);
        if (!mes.metricsChecks.checks.isEmpty()) {
            for (Check check : mes.metricsChecks.checks) {
                String label = check.getMeta().getLabel();
                if (!requestedCheckLabels.contains(label)) continue;
                checksSet.checks.add(check);
                foundLabels.add(label);
            }
        }
        ArrayList<String> missingLabels = new ArrayList<String>();
        for (String req : requestedSet) {
            if (foundLabels.contains(req)) continue;
            missingLabels.add(req);
        }
        if (!missingLabels.isEmpty()) {
            throw new IllegalArgumentException("The following check labels were not found: " + StringUtils.join(missingLabels, (String)", "));
        }
        return checksSet;
    }
}

