/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.internal.IInternalDataCatalogService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.document.Document;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexableField;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Explanation;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TopDocs;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class LuceneMigrationHelper {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.catalog.LuceneMigrationHelper");
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setLenient().create();

    public static List<String> getLuceneTokens(String fieldValue, String fieldToCompare, PerFieldAnalyzerWrapper perFieldAnalyzerWrapper) throws IOException {
        return LuceneMigrationHelper.getTokensFromStream(perFieldAnalyzerWrapper.tokenStream(fieldToCompare, fieldValue));
    }

    public static List<String> getLuceneTokens(Document readDoc, String fieldToCompare, PerFieldAnalyzerWrapper perFieldAnalyzerWrapper) {
        ArrayList<String> resp = new ArrayList<String>();
        try {
            for (IndexableField indexableField : readDoc.getFields(fieldToCompare)) {
                TokenStream ts3 = perFieldAnalyzerWrapper.tokenStream(fieldToCompare, indexableField.stringValue());
                resp.addAll(LuceneMigrationHelper.getTokensFromStream(ts3));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception while reading lucene tokens", (Throwable)e);
        }
        return resp;
    }

    private static List<String> getTokensFromStream(TokenStream ts) throws IOException {
        ArrayList<String> resp = new ArrayList<String>();
        ts.addAttribute(OffsetAttribute.class);
        CharTermAttribute charTermAttribute = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
        try (TokenStream tokenStream = ts;){
            ts.reset();
            while (ts.incrementToken()) {
                String term = charTermAttribute.toString();
                resp.add(term);
            }
            ts.end();
        }
        return resp;
    }

    public static void logLuceneExplanation(IndexSearcher searcher, Query q, IInternalDataCatalogService.Options options) throws IOException {
        LuceneMigrationHelper.logLuceneExplanation(searcher, q, options.getExplainDocId(), options.getExplainDocType());
    }

    public static void logLuceneExplanation(IndexSearcher searcher, Query q, String docId, String docType) throws IOException {
        if (!DKUApp.getParams().getBoolParam("dku.catalog.logLuceneExplainPlan", false)) {
            return;
        }
        if (docId == null) {
            return;
        }
        if (docType == null) {
            logger.warnV("Attempt to explain document [%s] but no document type was provided", new Object[]{docId});
            return;
        }
        try {
            IndexableType.forName((String)docType);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("unknown doc type : " + docType));
            return;
        }
        Integer docInt = LuceneMigrationHelper.getDocInt(searcher, docId, docType);
        if (docInt != null) {
            Explanation explanation = searcher.explain(q, docInt.intValue());
            logger.debug((Object)"explanation lucene :");
            logger.debug((Object)explanation.toString());
        }
    }

    private static Integer getDocInt(IndexSearcher searcher, String docId, String type) throws IOException {
        BooleanQuery q = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("_type", type)), BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("_id", docId)), BooleanClause.Occur.MUST).build();
        return LuceneMigrationHelper.getDocInt(searcher, (Query)q);
    }

    private static Integer getDocInt(IndexSearcher searcher, Query query) throws IOException {
        TopDocs idTopDocs = searcher.search(query, 2);
        if (idTopDocs.totalHits.value > 1L) {
            logger.warn((Object)"More than one doc found for explain query");
            return null;
        }
        if (idTopDocs.totalHits.value == 0L) {
            logger.warn((Object)"No matching docs found for explain query");
            return null;
        }
        return idTopDocs.scoreDocs[0].doc;
    }

    public static void logLuceneHighlight(LuceneResponseWrapper luceneResponse) {
        TreeMap luceneHighlightFragments = new TreeMap();
        luceneResponse.hits.forEach(hit -> hit.highlight.forEach((field, fragments) -> luceneHighlightFragments.put(String.join((CharSequence)".", hit._index, hit._type, hit._id, field), fragments)));
        logger.debugV("Lucene highlights%s%s", new Object[]{System.lineSeparator(), gson.toJson(luceneHighlightFragments)});
    }
}

