/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CategoricalEncoder
implements Processor {
    private static final long serialVersionUID = 1L;
    final String[] columns;
    final String[][] levels;
    final String[][] outputNames;
    final double[][] defaults;
    final List<Map<String, double[]>> encodings;

    public CategoricalEncoder(String[] columns, String[][] levels, String[][] outputNames, double[][][] encodings, double[][] defaults) {
        this.columns = columns;
        this.levels = levels;
        this.outputNames = outputNames;
        this.encodings = new ArrayList<Map<String, double[]>>(columns.length);
        for (int i = 0; i < columns.length; ++i) {
            HashMap<String, double[]> e = new HashMap<String, double[]>();
            for (int j = 0; j < levels[i].length; ++j) {
                e.put(levels[i][j], encodings[i][j]);
            }
            this.encodings.add(e);
        }
        this.defaults = defaults;
    }

    @Override
    public void process(RawObservation data) {
        for (int i = 0; i < this.columns.length; ++i) {
            double[] vals;
            String c = data.getAsString(this.columns[i]);
            double[] dArray = vals = c == null ? this.defaults[i] : this.encodings.get(i).get(c);
            if (vals == null) {
                vals = this.defaults[i];
            }
            for (int j = 0; j < this.defaults[i].length; ++j) {
                data.put(this.outputNames[i][j], vals[j]);
            }
        }
    }

    public String[] getColumns() {
        return this.columns;
    }

    public String[][] getLevels() {
        return this.levels;
    }

    public String[][] getOutputNames() {
        return this.outputNames;
    }

    public double[][] getDefaults() {
        return this.defaults;
    }

    public List<Map<String, double[]>> getEncodings() {
        return this.encodings;
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("CategoricalEncoder(");
        for (int i = 0; i < this.columns.length; ++i) {
            s.append(this.columns[i]).append(" coded [");
            Map<String, double[]> enc = this.encodings.get(i);
            for (int j = 0; j < this.levels[i].length; ++j) {
                s.append(this.levels[i][j]).append("->").append(Arrays.toString(enc.get(this.levels[i][j]))).append(", ");
            }
            s.append("]");
            if (i == this.columns.length - 1) continue;
            s.append(" ; ");
        }
        return s.append(")").toString();
    }
}

