/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.util.RawObservation;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Coercion {
    private static final String Digits = "(\\p{Digit}+)";
    private static final String HexDigits = "(\\p{XDigit}+)";
    private static final String Exp = "[eE][+-]?(\\p{Digit}+)";
    private static final String NUMERIC_REGEX = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");
    private final Map<String, Boolean> numeric;

    private static boolean isParseableToDouble(String s) {
        return NUMERIC_PATTERN.matcher(s).matches();
    }

    public Coercion(String[] columns, boolean[] numeric) {
        if (columns.length != numeric.length) {
            throw new IllegalArgumentException("columns and numeric must have same length");
        }
        this.numeric = new HashMap<String, Boolean>();
        for (int i = 0; i < columns.length; ++i) {
            this.numeric.put(columns[i], numeric[i]);
        }
    }

    public Coercion(Map<String, Boolean> numeric) {
        this.numeric = numeric;
    }

    public Boolean isNumeric(String column) {
        return this.numeric.get(column);
    }

    public Object coerce(String column, Object value) {
        Boolean num = this.numeric.get(column);
        if (num == null) {
            return value;
        }
        if (num.booleanValue()) {
            return this.coerceDouble(value);
        }
        if (value instanceof String) {
            if (((String)value).isEmpty()) {
                return null;
            }
            return value;
        }
        if (value instanceof Number) {
            return value.toString();
        }
        return null;
    }

    private Object coerceDouble(Object value) {
        if (value == null) {
            return value;
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String st = (String)value;
            if (Coercion.isParseableToDouble(st)) {
                return Double.parseDouble(st);
            }
            return null;
        }
        return null;
    }

    public RawObservation coerceObservation(RawObservation s) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : s.toMap().entrySet()) {
            result.put(e.getKey(), this.coerce(e.getKey(), e.getValue()));
        }
        return new RawObservation(result);
    }
}

