/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;
import java.util.Arrays;
import java.util.List;

public class Rescaler
implements Processor {
    private static final long serialVersionUID = 0L;
    private final String[] columns;
    private final double[] shifts;
    private final double[] inv_scales;

    public Rescaler(String[] columns, double[] shifts, double[] inv_scales) {
        this.columns = columns;
        this.shifts = shifts;
        this.inv_scales = inv_scales;
    }

    public Rescaler(List<String> columns, List<Double> shifts, List<Double> inv_scales) {
        this.columns = new String[columns.size()];
        this.shifts = new double[columns.size()];
        this.inv_scales = new double[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            this.columns[i] = columns.get(i);
            this.shifts[i] = shifts.get(i);
            this.inv_scales[i] = inv_scales.get(i);
        }
    }

    public String[] getColumns() {
        return Arrays.copyOf(this.columns, this.columns.length);
    }

    public double[] getShifts() {
        return Arrays.copyOf(this.shifts, this.shifts.length);
    }

    public double[] getInv_scales() {
        return Arrays.copyOf(this.inv_scales, this.inv_scales.length);
    }

    @Override
    public void process(RawObservation data) {
        for (int i = 0; i < this.columns.length; ++i) {
            String col = this.columns[i];
            Object x = data.get(col);
            if (x == null) continue;
            if (x instanceof Double) {
                data.put(col, ((Double)x - this.shifts[i]) * this.inv_scales[i]);
                continue;
            }
            data.setError("Column " + col + " could not be rescaled due to non-double value");
            return;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("Rescaler(");
        for (int i = 0; i < this.columns.length; ++i) {
            s.append(this.columns[i]).append(" (shift, inv_scale)=(").append(this.shifts[i]).append(", ").append(this.inv_scales[i]).append(")");
            if (i == this.columns.length - 1) continue;
            s.append(" ; ");
        }
        return s.append(")").toString();
    }
}

