# MDC system for Jupyter notebook

# Notes on what was tried but does not work, due to the complexity
# of dealing with loggers that we don't control (they are created by Tornado)
# 
#  - Filters defined in code
#  - Filters defined through jupyter_config.py
#  - Adapters
#
# The only thing that works is finding the formatter used by the root logger, and
# to wrap it by our own MDC-aware formatter

import logging
import threading
thread_local_mdc = None

# A simple thread-local key-value registry
class LoggingMDC(object):
    def __init__(self):
        global thread_local_mdc
        if thread_local_mdc is None:
            thread_local_mdc = threading.local()

    def get_mdc(self):
        ret = {}
        for k in dir(thread_local_mdc):
            if not k.startswith("__"):
                ret[k] = getattr(thread_local_mdc, k)
        return ret

    def set_mdc(self, key, value):
        setattr(thread_local_mdc, key, value)

    def clear_mdc(self):
        for k in self.get_mdc():
            delattr(thread_local_mdc, k)

# The formatter that prepends the MDC to the message of log records
class MDCFormatterWrapper(logging.Formatter):
    def __init__(self, parent):
        self.parent = parent

    def format(self, record):
        prep = ""
        for k, v in LoggingMDC().get_mdc().items():
            prep = "[%s=%s] %s" % (k, v, prep)

        record.msg = "%s %s" % (prep, record.msg)
        return self.parent.format(record)
