(function(){
    'use strict';

    const requestListElement = {
        bindings: {
            request: '<',
            users: '<',
            projectNames: '<',
            appNames: '<',
            pluginsList: '<'
        },
        templateUrl: '/static/dataiku/inbox/components/request-center/request-list/request-list-element/request-list-element.component.html',
        controller: function(RequestCenterService){
            this.isAboutProject = function(){
                return this.request.objectType.toLowerCase() === 'project';
            }
            this.isAboutApp = function() {
                return this.request.objectType.toLowerCase() === 'app';
            }
            this.isAboutObject = function(){
                return this.request.requestType.toLowerCase() === 'object_share';
            }
            this.isAboutInstanceAccess = function() {
                return this.request.requestType === 'INSTANCE_ACCESS';
            }
            this.isAboutPlugin = function(){
                return this.request.objectType.toLowerCase() === 'plugin';
            }
            this.isAboutCodeEnv = function(){
                return this.request.objectType.toLowerCase() === 'code_env';
            }
            this.pluginRequestTypeLabel = function(){
                return this.isAboutPlugin() && this.request.requestType === "UPDATE_PLUGIN" ? "update" : "installation";
            }
            this.codeEnvType = function(){
                return this.isAboutCodeEnv() && this.request.requestDetails.envLang.toLowerCase();
            }

            this.codeEnvLangLabel = function(){
                return this.isAboutCodeEnv() && RequestCenterService.getCodeEnvLangLabel(this.request.objectId, this.request.requestDetails.envLang);
            }

            this.$onChanges = changes => {
                if ((changes.request && this.isAboutObject()) || this.isAboutPlugin() || this.isAboutCodeEnv()) {
                    const envLang = this.isAboutCodeEnv() ? this.request.requestDetails.envLang : null;
                    const hasTargetName = this.isAboutCodeEnv() && this.request.requestDetails.source == 'MANUAL' && this.request.requestDetails.targetName;
                    const objectId = hasTargetName ? this.request.requestDetails.targetName : this.request.objectId;
                    this.objectLink = RequestCenterService.getObjectLink(this.request.objectProjectKey, this.request.objectType, objectId, this.pluginsList, envLang);
                }
            }
        }
    }

    angular.module('dataiku.inbox')
    .component('requestListElement', requestListElement);
})();
