(function(){
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/edit.js
     */
    app.controller('CopyDashboardModalController', function($scope, DataikuAPI, ActivityIndicator, StateUtils) {
        $scope.init = function(dashboard) {
            $scope.dashboard = dashboard;
            $scope.dashboard.newName = 'Copy of ' + dashboard.name;
            $scope.pointerMode = false;
        };

        $scope.copy = function() {
            DataikuAPI.dashboards.copy($scope.dashboard.projectKey, $scope.dashboard.id, $scope.dashboard.newName, !$scope.pointerMode)
                .error(setErrorInScope.bind($scope))
                .success(function(data) {
                    ActivityIndicator.success( $scope.dashboard.name + ' copied into ' + data.name + ', <a href=\'' + StateUtils.href.dashboard(data.id, data.projectKey, { name: data.name }) + '\' >view dashboard</a>.', 5000);
                    $scope.resolveModal();
                });
        }
    });
})();
