(function() {
    'use strict';

    angular.module('dataiku.modelevaluationstores').factory('ModelEvaluationStoreRenameService', renameService);

    function renameService(DataikuAPI, CreateModalFromTemplate) {
        function renameModelEvaluationStore({
                                         scope,
                                         state,
                                         projectKey,
                                         modelEvaluationStoreId,
                                         modelEvaluationStoreName,
                                         onSave = () => {}
                                     }) {
            CreateModalFromTemplate(
                "/templates/taggable-objects/rename-modal.html",
                scope,
                null,
                (newScope) => {
                    newScope.objectName = modelEvaluationStoreName;
                    newScope.uiState = { newName: modelEvaluationStoreName };

                    newScope.go = () => {
                        const newName = newScope.uiState.newName;
                        DataikuAPI.modelevaluationstores.rename(projectKey, modelEvaluationStoreId, newName).then(() => {
                            newScope.dismiss();
                            onSave(newName);
                            state.reload();
                        }, setErrorInScope.bind(newScope));
                    }
                });
        }

        return { renameModelEvaluationStore };
    }
})();
