(function() {
    'use strict';

    angular.module('dataiku.charts')
        .service('ChartContextualMenu', ChartContextualMenu);

    function ChartContextualMenu($rootScope, $stateParams, ChartFilters, ContextualMenu, AnimatedChartsUtils, DashboardFilters, DashboardUtils, ChartDrilldown, ChartFeatures, ChartHierarchyDimension, ChartDimension, ChartDrilldownType, translate, DRILL_UP_SOURCE, DRILL_DOWN_SOURCE) {

        const svc = {
            create: function(chartData, chartDef, chartStore, animation = {}) {
                const isInDashboard = DashboardUtils.isInDashboard();
                const contextualMenu = {
                    open: function({ event, filteringOptions = { filterableElements: [] }, hierarchyDrillableElements = [], nativeDrillableElements = [], customActions = [], type = 'measure' }) {
                        let canFilter, canDrillHierarchy, canDrillNative, menu;

                        const newScope = $rootScope.$new();
                        newScope.customActions = customActions;
                        newScope.ChartDrilldownType = ChartDrilldownType;

                        switch (type) {
                            case 'measure':
                                canFilter = (!isInDashboard || DashboardFilters.canCrossFilter($stateParams.pageId)) && filteringOptions.filterableElements.length > 0;
                                canDrillHierarchy = ChartFeatures.canDrillHierarchy(chartDef.type) && !!hierarchyDrillableElements.length && hierarchyDrillableElements.some(el => el.drilldown || el.drillup);
                                canDrillNative = !isInDashboard && !!nativeDrillableElements.length && nativeDrillableElements.some(el => el.elements.length);

                                if (canFilter || canDrillHierarchy || canDrillNative || customActions.length) {
                                    menu = new ContextualMenu({
                                        contextual: false,
                                        template: '/templates/simple_report/contextual-menu/chart-contextual-menu.html'
                                    });
                                    const data = {
                                        canFilter,
                                        canHierarchyDrillDown: canDrillHierarchy && hierarchyDrillableElements.some(el => el.drilldown),
                                        canHierarchyDrillUp: canDrillHierarchy && hierarchyDrillableElements.some(el => el.drillup),
                                        disableMultiDimensionalFiltering: filteringOptions.disableMultiDimensionalFiltering,
                                        filterableElements: filteringOptions.filterableElements,
                                        hierarchyDrillupElements: hierarchyDrillableElements.filter(el => el.drillup),
                                        hierarchyDrilldownElements: hierarchyDrillableElements.filter(el => el.drilldown),
                                        nativeDrillableElements,
                                        canDrillNative,
                                        drillDownHierarchy: contextualMenu.drillDownHierarchy,
                                        drillUpHierarchy: contextualMenu.drillUpHierarchy,
                                        drillDownNative: contextualMenu.drillDownNative,
                                        includeOnly: contextualMenu.includeOnly,
                                        exclude: contextualMenu.exclude,
                                        getHierarchyName: contextualMenu.getHierarchyName
                                    };
                                    newScope.data = angular.copy(data);
                                }

                                break;

                            case 'pivotTableHeader':
                                menu = new ContextualMenu({
                                    contextual: false,
                                    template: '/templates/simple_report/contextual-menu/pivot-table-header-contextual-menu.html'
                                });
                                break;
                            case 'background':
                                menu = new ContextualMenu({
                                    contextual: false,
                                    template: '/templates/simple_report/contextual-menu/chart-contextual-menu.html'
                                });
                                break;
                        }
                        if (!menu) {
                            return;
                        }
                        menu.scope = newScope;
                        menu.openAtXY(event.pageX, event.pageY);
                        menu.$menu.addClass('chart-contextual-menu');
                    },
                    includeOnly: (filterableElements) => {
                        if (isInDashboard) {
                            const filters = filterableElements.map((filterableElement) => {
                                const { dimension, axisElt, value } = filterableElement;
                                return ChartFilters.createFilter({
                                    column: dimension.column,
                                    columnType: dimension.type,
                                    isAGlobalFilter: true,
                                    excludeOtherValues: true,
                                    label: `ONLY ${dimension.column}: ${value}`,
                                    useMinimalUi: true,
                                    includeEmptyValues: false
                                }, {
                                    dimension,
                                    axisElt
                                });
                            });
                            $rootScope.$emit('crossFiltersAdded', {
                                filters,
                                wt1Args: {
                                    from: 'chart',
                                    action: 'contextual_menu',
                                    chartType: chartDef.type,
                                    filterType: 'include'
                                }
                            });
                        } else {
                            let filters = chartDef.filters;
                            filterableElements.forEach((filterableElement) => {
                                const { dimension, axisElt } = filterableElement;
                                const { oldFilter, newFilter } = ChartFilters.getIncludeOnly1DFilter(dimension, axisElt, filters);
                                if (!ChartFilters.areFiltersEqual(oldFilter, newFilter)) {
                                    filters = ChartFilters.updateOrAddFilter(filters, newFilter, oldFilter);
                                }
                            });
                            chartDef.filters = filters;
                        }
                    },
                    exclude: (filterableElements) => {
                        const filter = ChartFilters.getExcludeNDFilter(filterableElements);
                        if (isInDashboard) {
                            filter.isAGlobalFilter = true;
                            $rootScope.$emit('crossFiltersAdded', {
                                filters: [filter],
                                wt1Args: {
                                    from: 'chart',
                                    action: 'contextual_menu',
                                    chartType: chartDef.type,
                                    filterType: 'exclude'
                                }
                            });
                        } else if (!chartDef.filters.some(f => ChartFilters.areFiltersEqual(f, filter))){
                            chartDef.filters = ChartFilters.updateOrAddFilter(chartDef.filters, filter);
                        }
                    },
                    drillDownHierarchy: (drillableElement) => {
                        ChartDrilldown.handleDrillDown(chartDef, drillableElement.dimension, DRILL_DOWN_SOURCE.CONTEXTUAL_MENU, drillableElement.axisElt);
                    },
                    drillUpHierarchy: (drillableElement) => {
                        ChartDrilldown.handleDrillUp(chartDef, drillableElement.dimension, DRILL_UP_SOURCE.CONTEXTUAL_MENU);
                    },
                    drillDownNative: (drillableElement) => {
                        const { updatedFilters, newDateRange } = ChartDrilldown.getUpdateForNativeDrillDown(chartDef, drillableElement.axisElt, drillableElement.dimension);
                        if (newDateRange) {
                            _.set(chartDef, `${drillableElement.propertyName}.dateParams.mode`, newDateRange);
                        }
                        chartDef.filters = updatedFilters;
                    },
                    showForCoords: (coords, event, customActions, type) => {
                        const finalCoords = {
                            ...coords,
                            animation: AnimatedChartsUtils.getAnimationCoord(animation)
                        };
                        const filteringOptions = ChartFilters.getFilterableOptions(chartStore, chartData, finalCoords, chartDef);
                        const hierarchyDrillableElements = ChartDrilldown.getDrillableElements(chartStore, chartDef, chartData, finalCoords);
                        const binDrillableElements = filteringOptions.filterableElements.filter(el => ChartDimension.isDrillableForElement(chartDef, el.dimension, el.axisElt) && ChartDimension.isGroupedNumerical(el.dimension));
                        const dateDrillableElements = filteringOptions.filterableElements.filter(el => ChartDimension.isDrillableForElement(chartDef, el.dimension, el.axisElt) && !ChartDimension.isGroupedNumerical(el.dimension));
                        const nativeDrillableElements = [
                            {
                                drilldownType: ChartDrilldownType.BIN,
                                actionLabel: translate('CHARTS.CONTEXTUAL_MENU.DRILL_DOWN.BIN', 'Drill down on bin'),
                                elements: binDrillableElements
                            },
                            {
                                drilldownType: ChartDrilldownType.DATE,
                                actionLabel: translate('CHARTS.CONTEXTUAL_MENU.DRILL_DOWN.DATE', 'Drill down on date'),
                                elements: dateDrillableElements
                            }
                        ];

                        contextualMenu.open({ event, filteringOptions, hierarchyDrillableElements, nativeDrillableElements, customActions, type });
                    },
                    addContextualMenuHandler: (domElement, coords, customActions, type) => {
                        d3.select(domElement)
                            .on('contextmenu.contextualmenu', () => {
                                d3.event.preventDefault();
                                contextualMenu.showForCoords(coords, d3.event, customActions, type);
                            });
                    },
                    removeContextualMenuHandler: (el) => {
                        d3.select(el)
                            .on('contextmenu', null);
                    },
                    addChartContextualMenuHandler: (chart, getTargetElementProperties, getCustomActions) => {
                        d3.select(chart).on('contextmenu.contextualmenu', function() {
                            const target = d3.event.target;
                            const properties = getTargetElementProperties && getTargetElementProperties(target);
                            const customActions = getCustomActions ? getCustomActions(properties) : [];
                            if (!_.isNil(properties)) {
                                d3.event.preventDefault();
                                contextualMenu.showForCoords(properties.coords, d3.event, customActions);
                            } else if (ChartFeatures.canDrillHierarchy(chartDef.type) && customActions.length && target.classList.contains('chart-contextual-menu-anchor')) {
                                d3.event.preventDefault();
                                contextualMenu.open({ event: d3.event, customActions, type: 'background' });
                            }
                        });
                    },
                    removeChartContextualMenuHandler: (chart) => {
                        d3.select(chart).on('contextmenu', null);
                    },
                    getAnimationContext: function() {
                        return AnimatedChartsUtils.getAnimationContext(chartDef.animationDimension[0], animation);
                    },
                    getHierarchyName: function(dimension) {
                        return ChartHierarchyDimension.getDimensionHierarchyName(chartDef, dimension);
                    }
                };
                return contextualMenu;
            }
        };
        return svc;
    }
})();
