(function(){
'use strict';

    angular.module('dataiku.nestedFilters').directive('onEventConditionList', function($document, $window) {
        return {
           restrict: 'A',
           scope: {
               onEventConditionList: '<'
           },
           link: function ($scope, el, attr) {
               $scope.hideList = function (e) {
                    if (el !== e.target && !el[0].contains(e.target)) {
                        $scope.$apply(function () {
                            if($scope.$parent.c.$showList){
                               $scope.$parent.c.$showList = false;
                            }
                        });
                    }
               };

               $scope.computeDimensionsAfterScroll = function (e) {
                    if (el !== e.target && !el[0].contains(e.target)) {
                        if($scope.$parent.c.$showList){
                           $scope.$parent.computeDimensionsOnFilterEditor($scope.$parent.$index);
                           $scope.$digest();
                        }
                    }
               };

               $scope.computeDimensionsAfterResize = function (e) {
                    if($scope.$parent.c.$showList){
                          $scope.$parent.computeDimensionsOnFilterEditor($scope.$parent.$index);
                          $scope.$digest();
                    }
               };
               //Prefer mouseup to cover also click events on buttons which do not bubble up and hence not catched
               $document.on('mouseup', $scope.hideList);
               $document.on('wheel', $scope.computeDimensionsAfterScroll);
               angular.element($window).bind('resize', $scope.computeDimensionsAfterResize);

               $scope.$on('$destroy', function(){
                    $document.off('mouseup', $scope.hideList);
                    $document.off('wheel', $scope.computeDimensionsAfterScroll);
                    angular.element($window).unbind('resize', $scope.computeDimensionsAfterResize);
               });
            }
        }
    });
})();