(function() {
    "use strict";

    /**
     * <opals-help-center-container />
     */
    const opalsHelpCenterContainer = {
        templateUrl: "/static/dataiku/opals/opals-help-center-container/opals-help-center-container.component.html",
        controller: function opalsHelpCenterContainerController($scope, $element, OpalsService, OpalsMessageService, WT1) {

            this.helpCenterUrl = "";
            this.frameId = "help-center-frame";
            this.availability = "pending";

            this.$onInit = function() {
                OpalsService.getHelpCenterUrl().then((url) => {
                    this.helpCenterUrl = url;
                });
                OpalsService.isHelpCenterAvailable().then((isAvailable) => {
                    this.availability = isAvailable ? "available" : "unavailable";
                    if (this.availability === "available") {
                        const unregister = $scope.$watch(
                            () => $element.find(`#${this.frameId}`),
                            (newVal) => {
                                if (newVal.length > 0) {
                                    OpalsService.setHelpCenterFrame(newVal[0]);
                                    OpalsService.focusHelpCenterFrame();
                                    unregister();
                                }
                            }
                        );
                    } else {
                        OpalsService.getHelpCenterUrl().then((url) => {
                            WT1.event("opals-help-load-error", { opalsUrl: url.toString() });
                        });
                    }
                });
            };

            this.onMessage = OpalsMessageService.handleMessageEvent;
        },
    };

    angular.module("dataiku.opals").component("opalsHelpCenterContainer", opalsHelpCenterContainer);
})();
