/* global describe, it, beforeEach, ChartFeaturesTestUtils */

describe('chart features stacked_areas', function () {

    const chartType = 'stacked_area';

    /* Get tests helpers */
    const { expectIdToBeVisible, expectIdToBeHidden, renderTemplate } = ChartFeaturesTestUtils;

    describe('variant normal', function () {

        const chartVariant = 'normal';

        /* Initialize each test */
        beforeEach(() => {
            ChartFeaturesTestUtils.initEachTest();
            ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
        });

        it('doesn\'t have regression line options', function () {
            renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
            expectIdToBeHidden('qa_charts_regression-line-form');
        })
    
    });

    describe('variant stacked_100', function () {

        const chartVariant = 'stacked_100';

        /* Initialize each test */
        beforeEach(() => {
            ChartFeaturesTestUtils.initEachTest();
            ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
        });


        it('doesn\'t have regression line options', function () {
            renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
            expectIdToBeHidden('qa_charts_regression-line-form');
        })
    });
});
