import numpy as np
import six


def filter_columns_without_enough_values(df, columns):
    filtered_columns = []
    for col in columns:
        if np.sum(df[col].notnull()) > 1: # we filter out columns with less than 2 values
            filtered_columns.append(col)
    return filtered_columns


def generic_check_compute_arguments(datetime_column, groupby_columns):
    if not isinstance(datetime_column, six.text_type):
        cause = "datetime_column param must be of type {}. Got: {}".format(six.text_type, type(datetime_column))
        raise ValueError(cause)

    if groupby_columns:
        if not isinstance(groupby_columns, list):
            cause = "groupby_columns param must be an array of {}. Got: {}".format(six.text_type, type(groupby_columns))
            raise ValueError(cause)

        for col in groupby_columns:
            if not isinstance(col, six.text_type):
                cause = "groupby column '{}' must be of type {}. Got: {}".format(col, six.text_type, type(col))
                raise ValueError(cause)
