options(echo=T)
args <- commandArgs(TRUE);
print (paste("Executing R script: ", args));

runsRemotely = FALSE;
jobCwd = NULL;
dkuExecEnv = NULL;
scriptFile = args[1]
if (file.exists("remote-run-env-def.json")) {
    library("RJSONIO");
    dkuExecEnv = RJSONIO::fromJSON(file("remote-run-env-def.json"))
    runsRemotely = dkuExecEnv$runsRemotely
}

# print("DKU EXEC ENV")
# print(dkuExecEnv)

if (! is.null(dkuExecEnv) && runsRemotely) {
    # running in yarn-cluster mode

    # file has been distributed, so it's in the local dir now
    scriptFile = basename(args[1])
    
    jobId = dkuExecEnv$jobId
    do.call(Sys.setenv, as.list(dkuExecEnv$env)) # as gruik as Python
    
    unzippedPackagesPath = file.path('.', '__dku_rFiles')

    added = 0
    for (package in dkuExecEnv$r$packages) {
        packageName = package["key"]
        packageFolder = package["value"]
        localPackageFolder = file.path(unzippedPackagesPath, packageName)
        zipName = dkuExecEnv$zippedFolders[packageFolder]
        
        print(paste0("Unzip ", packageName, " originally at ", packageFolder, " and now at ", zipName, " to ", localPackageFolder))
        
        unzip(zipName, exdir=localPackageFolder)
        added = added + 1
    }
    if (added > 0) {
        .libPaths(c(.libPaths(), normalizePath(unzippedPackagesPath))) # a bit gruik
    }
} else {
    if (! is.null(dkuExecEnv)) {
        jobCwd = dkuExecEnv$cwd;
        do.call(Sys.setenv, as.list(dkuExecEnv$env)) # as gruik as Python
        # also put R_LIBS and R_LIBS_USER in the path (otherwise R will run with Livy's env)
        r_libs = strsplit(Sys.getenv("R_LIBS"), ":")[[1]]
        r_libs_user = strsplit(Sys.getenv("R_LIBS_USER"), ":")[[1]]
        libs_chunks = unique(c(r_libs, r_libs_user))
        .libPaths(c(.libPaths(), libs_chunks)) # a bit gruik
    }
}

tryCatch({
	source(scriptFile, echo=TRUE, keep.source=T, local=TRUE);
	
}, error = function(err){
    library("RJSONIO");

	print("********** R code failed **********");

	msg <- err$message;
    try({
	    if (!(is.character(msg) && length(msg) == 1)) {
	        msg <- RJSONIO::toJSON(msg);
	    }
    });
    msg <- toString(msg);
	print(paste("Error evaluating R code:", msg));

	rErrorType = class(err)[1];
	
	jsonErr = list(message = msg,
				   detailedMessage = paste(rErrorType, ": ", msg),
				   errorType = paste("R.", rErrorType));
	jsonData = RJSONIO::toJSON(jsonErr);
	if (runsRemotely) {
	    # send over http
	    tryCatch({
            library("httr");
            
            # custom versions of methods in dku_internals.R
            dku__get_auth_headers <- function() {
                call_origin <- Sys.getenv("DKU_CALL_ORIGIN")
                api_ticket <- Sys.getenv("DKU_API_TICKET", unset=NA)
                return(add_headers("X-DKU-APITicket"=api_ticket, "X-DKU-CallOrigin"=call_origin))
            }
            dku__get_backend_url <- function(path) {
                prefix = "/dip/api/tintercom"
                port = Sys.getenv("DKU_BACKEND_PORT")
                host = Sys.getenv("DKU_BACKEND_HOST")
                protocol = Sys.getenv("DKU_BACKEND_PROTOCOL")
                if(is.null(port) || port=="") {
                  stop("DKU_BACKEND_PORT isn't defined")
                }
                if(is.null(host) || host=="") {
                  host = "127.0.0.1"
                }
                return(paste0(protocol, "://", host, ":", port, prefix, path))
            }
            dku__get_jek_url <- function(path) {
              prefix = "/kernel/tintercom"
              port = Sys.getenv("DKU_SERVER_PORT")
              host = Sys.getenv("DKU_SERVER_HOST")
              protocol = Sys.getenv("DKU_SERVER_PROTOCOL")
              return(paste0(protocol, "://", host, ":", port, prefix, path))
            }
            dku__get_jek_or_backend_url <- function(path) {
              serverKind <- Sys.getenv("DKU_SERVER_KIND")
              if (is.null(serverKind) || serverKind != "JEK") {
                # Notebook mode
                return(dku__get_backend_url(path))
              } else {
                # Flow mode
                return(dku__get_jek_url(path))
              }
            }
            dku_intercom__get_httr_config <- function() {
                if (Sys.getenv("DKU_SERVER_PROTOCOL")) {
                    tmpFilePath <- tempfile(pattern='r-ssl-cert-')
                    cert <- Sys.getenv("DKU_SERVER_CERT")
                    if (startsWith(cert, "b64:")) {
                        cert <- rawToChar(jsonlite::base64_dec(substr(cert, 5, 10000000)))
                    }
                    write(cert, tmpFilePath)
                    return(config(cainfo = tmpFilePath))
                } else {
                    return(config())
                }
            }

            tmpFilePath <- tempfile(pattern='r-data-')
            # Write a temp file
            file.create(tmpFilePath)
            tmpFileConn <- file(tmpFilePath, "wb")
            write(jsonData, tmpFileConn)
            close(tmpFileConn)
            saveErrorUrl = dku__get_jek_or_backend_url("/containers/put-file-multipart")
            resp = POST(saveErrorUrl, body = list(executionId=jobId, fileKind="FILTERED_PATHS", path="error.json", expand="false", file=upload_file(tmpFilePath, type="text/json"), fileName="error.json"), encode="multipart", dku__get_auth_headers(), dku_intercom__get_httr_config)
            print(paste0("Sent error.json : ", content(resp, "text")))
	    }, error = function(err2){
            print("********** Error sending failed **********");
            print (paste("Error sending back error: ", err2));
	    });
	} else {
        # simply write to local filesystem
        if (! is.null(jobCwd)) {
            errorJsonPath = file.path(jobCwd, "error.json")
        } else {
            errorJsonPath = "error.json"
        }
        write(jsonData, file = "error.json");
	}
	quit("no", 1 ,FALSE);
});
