/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SocketBlockLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.io.SocketBlockLinkIOException;
import com.dataiku.dip.io.SocketBlockLinkInteraction;
import com.dataiku.dip.io.SocketBlockLinkInvalidLengthException;
import com.dataiku.dip.io.SocketBlockLinkKernelException;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class SecretProtectedKernelLink
extends SocketBlockLink {
    private final String secret;
    private static Logger logger = Logger.getLogger((String)"dku.link.secret_protected");

    public SecretProtectedKernelLink(String secret, PortRangeParams portRange, SSLContext ctx) throws IOException {
        super(portRange, ctx);
        this.secret = secret;
    }

    public SecretProtectedKernelLink(String secret, PortRangeParams portRange) throws IOException {
        super(portRange);
        this.secret = secret;
    }

    public SecretProtectedKernelLink(String secret) throws IOException {
        super(new PortRangeParams());
        this.secret = secret;
    }

    public String getSecret() {
        return this.secret;
    }

    public void waitForProcess(int timeout) throws IOException {
        int secretBytesLength = this.secret.getBytes(StandardCharsets.UTF_8).length;
        int nbAttempts = 0;
        long startedWaiting = System.currentTimeMillis();
        while (!this.getBlockLink().hasSocket() && System.currentTimeMillis() - startedWaiting < (long)timeout) {
            ++nbAttempts;
            this.waitForConnection(timeout);
            try {
                String responseSecret = this.receiveStringResponse(secretBytesLength);
                if (this.secret.equals(responseSecret)) {
                    logger.info((Object)"Connected to kernel");
                    continue;
                }
                throw new SecurityException("Kernel didn't reply with the secret.\nExpected :\n" + this.secret + "\nGot :\n" + responseSecret);
            }
            catch (SocketBlockLinkInvalidLengthException e) {
                block12: {
                    if (nbAttempts < 3) {
                        logger.warn((Object)"Invalid initial block, socket probably hijacked by another process", (Throwable)e);
                        try {
                            DKUtils.execAndLog((String[])new String[]{"lsof", "-i", ":" + this.getPort()}, (Map)DKUtils.getEnvironment());
                        }
                        catch (Exception e2) {
                            logger.warn((Object)"Failed to inspect", (Throwable)e2);
                        }
                    } else {
                        logger.warn((Object)"Invalid initial block, socket probably hijacked by another process");
                    }
                    try {
                        this.getBlockLink().getSocket().close();
                    }
                    catch (Exception e2) {
                        if (nbAttempts < 3) {
                            logger.warn((Object)"Failed to close unwanted connection", (Throwable)e2);
                            break block12;
                        }
                        logger.warn((Object)"Failed to close unwanted connection");
                    }
                }
                this.getBlockLink().setSocket(null);
            }
        }
        if (!this.getBlockLink().hasSocket()) {
            throw new SecurityException("Unable to establish socket connection after " + timeout + "ms and " + nbAttempts + " attempts");
        }
    }

    public void waitForProcess() throws IOException {
        int waitForTcpConnect = DKUApp.getParams().getIntParam("dku.kernel.tcpConnectTimeoutMS", Integer.valueOf(60000));
        this.waitForProcess(waitForTcpConnect);
    }

    public AcknowledgeResponse acknowledgeLastCall(DSSKernelBase kernel, String task, String errorMessage) throws IOException {
        try {
            SocketBlockLinkInteraction interaction = this.newInteraction();
            interaction.withExceptionIfNullMessage(errorMessage);
            if (StringUtils.isNotBlank((String)task)) {
                interaction.withRequest(new AcknowledgeRequest(task));
            }
            interaction.expectsObject(AcknowledgeResponse.class);
            AcknowledgeResponse resp = (AcknowledgeResponse)interaction.executeAsync().get();
            logger.info((Object)("Got acknowledgment : " + (resp == null ? "null" : JSON.pretty((Object)resp))));
            if (resp == null) {
                throw new SocketBlockLinkIOException("Failed to get ack", null);
            }
            if (!resp.ok) {
                throw new SocketBlockLinkKernelException(errorMessage, resp.error);
            }
            return resp;
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail(kernel);
            throw kernel.maybeRethrowAsProcessDied(e);
        }
    }

    public static class AcknowledgeRequest {
        public final String task;

        public AcknowledgeRequest(String task) {
            this.task = task;
        }
    }

    public static class AcknowledgeResponse {
        public boolean ok;
        public long count;
        public SocketBlockLinkInteraction.SocketBlockLinkKernelError error;
        public String reason;
    }
}

